Program CUPREX;
Uses Graph, Crt, Dos;
{$R+}
{$S+}

const  MaxZvetseni = 1000;
       MinZvetseni = 2;
       MaxX = 630;
       MaxY = 350;
       MinX = 10;
       MinY = 10;
       CenterX = (MaxX - MinX) div 2 + MinX;
       CenterY = (MaxY - MinY) div 2 + MinY;
       Rmax = 20;
       RBmax = 5;
       Vlevo = 1;
       Vpravo = 2;
       Nahoru = 3;
       Dolu = 4;
       Jednotka = 1;

       ActNic = 0;
       ActNovySpoj = 1;
       ActDokonciSpoj = 2;
       ActPosunBodu = 3;
       ActOznaceni = 4;
       ActKonec = 5;

       Pripona = 'CUP';

       elCuprex = 'CUPREX';
       elNazev = 'NAZEV';
       elSkupina = 'SKUPINA';
       elObrys = 'OBRYS';
       elSpoje = 'SPOJE';
       elBody = 'BODY';
       elClose = '/';

       klfNahoru = #72;
       klfDolu = #80;
       klfVlevo = #75;
       klfVpravo = #77;
       klEnter = #13;
       klEsc = #27;
       klfAltF4 = #45;
       klfIns = #82;
       klfDel = #83;

       saZamcena = 1;
       saOznacena = 2;
       saRozbalena = 4;

type     Sour = Real;
        TSmer = Byte;
       TNazev = String[64];
        Znaky = set of Char;
    CuprexPtr = ^TCuprex;
      CaraPtr = ^TCara;
{ Hlavni datove prvky programu }
   SkupinaPtr = ^TSkupina;
       BodPtr = ^TBod;
      SpojPtr = ^TSpoj;
     ObrysPtr = ^TObrys;

   TSkupina = Record
               Xofs, Yofs : Sour;             {Relativni pozice vuci Master}
               Nazev : TNazev;                {Nazev skupiny}
               Master, Sub : SkupinaPtr;      {Nadrazena skupina a podskupina}
               MasterCuprex : CuprexPtr;      {Nadrazeny cuprex}
               Predchozi, Dalsi : SkupinaPtr; {Ostatni skupiny a podskupiny}
               Attr : Byte;                   {Atributy skupiny viz konstanty sa}
               Vnoreni : Byte;                {Stupen vnoreni podskupiny}
              end;
       TBod = Record
               X, Y : Sour;
               Xofs, Yofs : Sour;            {Relativni pozice vuci Master}
               Stupen : Word;                {Stupen uzlu}
               Index : Word;                 {Cislo bodu - kvuli zapisu do souboru}
               Dira : Byte;                  {Prumer diry, 0=bez diry}
               Master : SkupinaPtr;          {Skupina, do ktere bod patri}
               Predchozi, Dalsi : BodPtr;    {Ostatni body}
              end;
      TSpoj = Record
               Zacatek, Konec : BodPtr;      {Body, ktere spoj spojuje}
               Group : Word;                 {Skupina vyberu - zastarale}
               Tloustka : Word;              {Sirka vodive cesty}
               Predchozi, Dalsi : SpojPtr;   {Ostatni spoje}
              end;
     TObrys = Record
               Xofs, Yofs : Sour;            {Relativni pozice vuci Master}
               Master : SkupinaPtr;          {Skupina, do ktere obrys patri}
               HlavniCara : CaraPtr;         {Pocatecni cara obrysu}
               Predchozi, Dalsi : ObrysPtr;  {Ostatni obrysy}
              end;

    TCuprex = Record
               Nazev : TNazev;               {Nazev prvku}
               Soubor : String[12];
               PocetBodu : Word;
               PocetSpoju : Word;
               HlavniSkupina : SkupinaPtr;   {Seznam skupin}
               HlavniSpoj : SpojPtr;         {Seznam spoju}
               HlavniBod : BodPtr;           {Seznam bodu}
               HlavniObrys : ObrysPtr;       {Seznam obrysu}
               Predchozi, Dalsi : CuprexPtr; {Ostatni plosne spoje}
              end;
      TCara = Record
               Xofs, Yofs : Sour;            {Relativni pozice vuci Master}
               Master : ObrysPtr;            {Nadrazeny prvek}
               Predchozi, Dalsi : CaraPtr;   {Ostatni cary}
              end;
    TPohled = Object

              end;

var Editor : Record
              Pohled : Record
                        Xpos, Ypos : Sour;
                        LastXpos, LastYpos : Sour;
                        Xmed, Ymed : Integer;
                        Zvetseni : Word;
                        KrokZvetseni : Integer;
                       end;
              Grid   : Record
                        On : Boolean;
                        Modul : Word;
                        Xpos, Ypos : Sour;
                       end;
              PointMode : Byte;
              RMax : Word; {maximalni vzdalenost kurzoru od usecky, aby byla nalezena}
              RbMax : Word; {maximalni vzdalenost kurzoru od bodu, aby byl nalezen}
              PouzivanyBod : BodPtr;
              Akce : Byte;
              Mx, My: Word;
              MouseMoved : Boolean;
              PohledMoved : Boolean;
             end;
    MaxAvMem, MinAvMem : Longint;
    HlavniCuprex : CuprexPtr;
    AktualniCuprex : CuprexPtr;
    AktualniSkupina : SkupinaPtr;
    AktualniBod, MinulyBod : BodPtr;
    AktualniSpoj : SpojPtr;

    regs : registers;

   type GrPointMask = array[1..2,0..15] of Word;
        Proc        = procedure;

{******************* MASKY GRAFIKYCH KURZORU *********************}
{1-Maska obrazovky; 2-Maska kurzoru;}
   Const Kursor   : GrPointMask = ( ( $3FFF, $1FFF, $0FFF, $07FF,
                                      $03FF, $01FF, $00FF, $007F,
                                      $003F, $001F, $001F, $00FF,
                                      $30FF, $F87F, $F87F, $FC7F ),

                                    ( $0000, $4000, $6000, $7000,
                                      $7800, $7C00, $7E00, $7F00,
                                      $7F80, $7FC0, $7C00, $4600,
                                      $0600, $0300, $0300, $0000 ) );

         Kriz     : GrPointMask = ( ( $FFFF, $FFFF, $FFFF, $FFFF,
                                      $FFFF, $FFFF, $FFFF, $FFFF,
                                      $FFFF, $FFFF, $FFFF, $FFFF,
                                      $FFFF, $FFFF, $FFFF, $FFFF ),

                                    ( $0100, $0100, $0100, $0100,
                                      $0100, $0000, $0000, $F93E,
                                      $0000, $0000, $0100, $0100,
                                      $0100, $0100, $0100, $0000 ) );

         Hodiny   : GrPointMask = ( ( $F839, $E008, $C004, $8003,
                                      $8003, $0001, $0001, $0001,
                                      $0001, $0001, $8003, $8003,
                                      $C007, $E00F, $F83F, $FFFF ),

                                    ( $07C6, $1FF7, $383B, $600C,
                                      $600C, $C006, $C006, $DF06,
                                      $C106, $C106, $610C, $610C,
                                      $3838, $1FF0, $07C0, $0000 ) );

         Sipka    : GrPointMask = ( ( $003F, $003F, $003F, $07FF,
                                      $03FF, $11FF, $18FF, $1C7F,
                                      $1E3F, $1F1F, $FF8F, $FFCF,
                                      $FFFF, $FFFF, $FFFF, $FFFF ),

                                    ( $0000, $7F80, $6000, $5000,
                                      $4800, $4400, $4200, $4100,
                                      $4080, $1010, $0000, $0000,
                                      $0000, $0000, $0000, $0000 ) );

         Krizek   : GrPointMask = ( ( $F1FF, $F1FF, $F1FF, $001F,
                                      $001F, $001F, $F1FF, $F1FF,
                                      $F1FF, $FFFF, $FFFF, $FFFF,
                                      $FFFF, $FFFF, $FFFF, $FFFF ),

                                    ( $0000, $0400, $0400, $0400,
                                      $7FC0, $0400, $0400, $0400,
                                      $0000, $0000, $0000, $0000,
                                      $0000, $0000, $0000, $0000 ) );

{*************** SOURADNICE VZTAZNYCH BODU KURZORU MYSI **********}
   SipkaX   = 15;
   SipkaY   = 7;
   KrizX    = 7;
   KrizY    = 7;
   HodinyX  = 8;
   HodinyY  = 8;
   OtaznikX = 5;
   OtaznikY = 5;

Function  MouseIsPresent : boolean;
   begin
    regs.ax:=0;
    intr($33,regs);
   if regs.ax = 0 then
      MouseIsPresent := false
   else
      MouseIsPresent := true;
  end;

Procedure ShowPointer;
   begin
    regs.ax:=1;
    intr($33,regs);
   end;

Procedure HidePointer;
   begin
    regs.ax:=2;
    intr($33,regs);
   end;

Function  MouX : Word;
   begin
    regs.ax:=3;
    intr($33,regs);
    MouX:=regs.cx;
   end;

Function  MouY : Word;
   begin
    regs.ax:=3;
    intr($33,regs);
    MouY:=regs.dx;
   end;

Procedure MouseSetPos(X,Y : Word);Assembler;
   Asm
      Mov Ax, 04
      Mov Cx, X
      Mov Dx, Y
      Int 33h
   end;

Function LbPressed : Boolean;
   begin
    regs.ax:=3;
    intr($33,regs);
    LbPressed:=(regs.bx and 1) <> 0;
   end;

Function RbPressed : Boolean;
   begin
    regs.ax:=3;
    intr($33,regs);
    RbPressed:=(regs.bx and 2) <> 0;
   end;

Procedure MouseRange(X1,Y1,X2,Y2 : Word);Assembler;
   Asm
      Mov Ax, 07
      Mov Cx, X1
      Mov Dx, X2
      Int 33h
      Mov Ax, 08
      Mov Cx, Y1
      Mov Dx, Y2
      Int 33h
   end;

Procedure MouseSetGrCurs(X,Y : Integer; PointerMask : GrPointMask);Assembler;
   Asm
      Mov Ax, 09
      Mov Bx, X
      Mov Cx, Y
      Les Dx, PointerMask
      Int 33h
   end;

Procedure MouseHandleEvent(EventMask : Word;var Handle : Proc);Assembler;
{ Nastaveni obsluzne rutiny udalosti mysi }
   Asm
      Mov Ax, 0Ch
      Mov Cx, EventMask
      Lea Dx, Handle
      Int 33h
   end;


{konecne vlastni procedury a funkce}
Function PohledNaSourX(P : Word) : Sour;
begin
 PohledNaSourX:=((P-Editor.Pohled.Xmed) / (Editor.Pohled.Zvetseni / 100) + Editor.Pohled.Xpos);
end;

Function PohledNaSourY(P : Word) : Sour;
begin
 PohledNaSourY:=((P-Editor.Pohled.Ymed) / (Editor.Pohled.Zvetseni / 100) + Editor.Pohled.Ypos);
end;

Function SourNaPohled(S,Pozice:Sour;Offset:Integer):Integer;
var R : Real;
begin
 R:=((S-Pozice) * (Editor.Pohled.Zvetseni / 100) + Offset);
 SourNaPohled:= Round(R);
end;

Function SourNaStr(X : Sour) : String;
var Sint, Sfr : String[11];
    Lint, Lfr : Longint;
begin
 Lint:=Trunc(X);
 Lfr:=Round(Frac(X)*100000);
 Str(Lint,Sint);
 Str(Lfr,Sfr);
 SourNaStr:=Sint + '.' + Sfr;
end;

Function MouXSour : Sour;
begin
 MouXsour:=PohledNaSourX(MouX);
end;

Function MouYSour : Sour;
begin
 MouYsour:=PohledNaSourY(MouY);
end;

Procedure GetMouseMove;
begin
 If (Editor.Mx = MouX) AND (Editor.My = MouY) then Editor.MouseMoved := FALSE
   else
  begin
   Editor.Mx := MouX;
   Editor.My := MouY;
   Editor.MouseMoved := TRUE;
  end;
end;

Procedure GetPohledMove;
begin
 If (Editor.Pohled.LastXpos = Editor.Pohled.Xpos) AND
    (Editor.Pohled.LastYpos = Editor.Pohled.Ypos) then Editor.PohledMoved := FALSE
   else
  begin
   Editor.Pohled.LastXpos := Editor.Pohled.Xpos;
   Editor.Pohled.LastYpos := Editor.Pohled.Ypos;
   Editor.PohledMoved := TRUE;
  end;
end;

Function Sgn(X:Real):ShortInt;
begin
 If X>0 then Sgn:=1 else
  if X<0 then Sgn:=-1 else
   Sgn:=0;
end;

Function ToGrid(X : Sour) : Sour;
begin
 If Editor.Grid.On then
 ToGrid:=Round(X / Editor.Grid.Modul) * Editor.Grid.Modul else ToGrid:=X;
end;

Procedure HledejBodIndex(var Bod : BodPtr; Cuprex : CuprexPtr; Index : Word);
var TempBod : BodPtr;
begin
 If Cuprex <> nil then
  begin
   TempBod:=Cuprex^.HlavniBod;
   Bod:=nil;
   While TempBod <> nil do
    begin
     If TempBod^.Index = Index then Bod := TempBod;
     TempBod := TempBod^.Dalsi;
    end;
  end;
end;

Procedure HledejBodPohled(var Bod : BodPtr; Cuprex : CuprexPtr; Xp, Yp : Word);
var TempBod : BodPtr;
    R, Rmin : Sour;
    X, Y : Sour;
begin
 If Cuprex <> nil then
  begin
   TempBod:=Cuprex^.HlavniBod;
   X:=PohledNaSourX(Xp);
   Y:=PohledNaSourY(Yp);
   Rmin:= Editor.Rbmax / (Editor.Pohled.Zvetseni / 100);
   Bod:=nil;
   While TempBod <> nil do
    begin
     R:=Round(Sqrt(Sqr(TempBod^.X-X)+Sqr(TempBod^.Y-Y)));
     If R < Rmin then
      begin
       Rmin:= R;
       Bod := TempBod;
      end;
     TempBod := TempBod^.Dalsi;
    end;
  end;
end;

Procedure HledejSpojPohled(var Spoj : SpojPtr; Cuprex : CuprexPtr; Xp, Yp : Word);
var TempSpoj : SpojPtr;
    X0, Y0, Xt, Yt, ux, uy : Sour;
    R, Rmin, X, Y : Sour;
    t : Real;
begin
 If AktualniCuprex <> nil then
  begin
   TempSpoj:=AktualniCuprex^.HlavniSpoj;
   X:=PohledNaSourX(Xp);
   Y:=PohledNaSourY(Yp);
   Rmin:= Editor.Rmax / (Editor.Pohled.Zvetseni / 100);
   Spoj:=nil;
   While TempSpoj <> nil do
    begin
     X0:=TempSpoj^.Zacatek^.X;
     Y0:=TempSpoj^.Zacatek^.Y;
     ux:=TempSpoj^.Konec^.X-TempSpoj^.Zacatek^.X;
     uy:=TempSpoj^.Konec^.Y-TempSpoj^.Zacatek^.Y;
     If ux+uy <> 0 then
      begin
       t:=(-1)*(ux*(X0-X)+uy*(Y0-Y))/(ux*ux+uy*uy);
       If T>1 then T:=1;
       If T<0 then T:=0;
       Xt:=X0+Round(ux*t);
       Yt:=Y0+Round(uy*t);
       R:=Round(sqrt(sqr(Xt-X)+sqr(Yt-Y)));
       If R < Rmin then begin Spoj:=TempSpoj; Rmin:=R; end;
      end;
     TempSpoj := TempSpoj^.Dalsi;
    end;
  end;
end;


Procedure Vzdalenost(X1, Y1, X2, Y2, Xm, Ym : Sour; var R : Sour);
var Xt, Yt, ux, uy : Sour;
    t : Real;
begin
  ux:=X2-X1;
  uy:=Y2-Y1;
  If ux+uy <> 0 then
   begin
    t:=(-1)*(ux*(X1-Xm)+uy*(Y1-Ym))/(ux*ux+uy*uy);
    If T > 1 then T:=1;
    If T < 0 then T:=0;
    Xt:=X1 + (ux*t);
    Yt:=Y1 + (uy*t);
    R:=(sqrt(sqr(Xt-Xm)+sqr(Yt-Ym)));
   end;
end;

Procedure HledejSpoje(X1, Y1, X2, Y2 : Sour; Posledni : SpojPtr);
var TempSpoj : SpojPtr;
begin
{ TempSpoj:=Posledni;
 While TempSpoj <> nil do
  begin
   TempSpoj^.Group := 0;
   TempSpoj := TempSpoj^.Predchozi;
  end;
 TempSpoj:=Posledni;
 While TempSpoj <> nil do
  begin
   If (Sgn(X1-X2) = Sgn(TempSpoj^.Zacatek^.X-X2))AND
      (Sgn(X2-X1) = Sgn(TempSpoj^.Zacatek^.X-X1))AND
      (Sgn(Y1-Y2) = Sgn(TempSpoj^.Zacatek^.Y-Y2))AND
      (Sgn(Y2-Y1) = Sgn(TempSpoj^.Zacatek^.Y-Y1))AND
      (Sgn(X1-X2) = Sgn(TempSpoj^.Konec^.X-X2))AND
      (Sgn(X2-X1) = Sgn(TempSpoj^.Konec^.X-X1))AND
      (Sgn(Y1-Y2) = Sgn(TempSpoj^.Konec^.Y-Y2))AND
      (Sgn(Y2-Y1) = Sgn(TempSpoj^.Konec^.Y-Y1)) then TempSpoj^.Group := 1;
   TempSpoj := TempSpoj^.Predchozi;
  end;}
end;

Procedure HledejVetev(Cuprex : CuprexPtr; Spoj : SpojPtr);

 procedure OznacDalsi(Bod : BodPtr);
 var TempSpoj : SpojPtr;
 begin
  TempSpoj:=Cuprex^.HlavniSpoj;
  While TempSpoj <> nil do
   begin
    If TempSpoj^.Group <> 1 then
     begin
      If TempSpoj^.Zacatek = Bod then begin TempSpoj^.Group:=1; OznacDalsi(TempSpoj^.Konec); end;
      If TempSpoj^.Konec = Bod then begin TempSpoj^.Group:=1; OznacDalsi(TempSpoj^.Zacatek); end;
     end;
    TempSpoj := TempSpoj^.Dalsi;
   end;
 end;

var TempSpoj : SpojPtr;
begin
 If Cuprex <> nil then
  begin
   TempSpoj:=Cuprex^.HlavniSpoj;
    While TempSpoj <> nil do
     begin
      TempSpoj^.Group := 0;
      TempSpoj := TempSpoj^.Dalsi;
     end;
   If Spoj <> nil then
    begin
     OznacDalsi(Spoj^.Zacatek);
     OznacDalsi(Spoj^.Konec);
    end;
  end;
end;

Procedure ZakonciBody(Cuprex : CuprexPtr);
var TempBod : BodPtr;
begin
 If Cuprex <> nil then
  Begin
   TempBod:=Cuprex^.HlavniBod;
   While TempBod <> nil do
    begin
     If TempBod^.Stupen = 1 then TempBod^.Dira:=4;
     TempBod := TempBod^.Dalsi;
    end;
  end;
end;

Procedure VytvorBod(var Bod : BodPtr; Cuprex : CuprexPtr; Skupina : SkupinaPtr; X, Y : Sour; Index : Word);
var NovyBod : BodPtr;
begin
 If Cuprex <> nil then
  begin
   New(NovyBod);
   NovyBod^.X := X;
   NovyBod^.Y := Y;
   NovyBod^.Index := Index;
   NovyBod^.Stupen := 0;
   NovyBod^.Dira := 0;
   NovyBod^.Master:=Skupina;
   NovyBod^.Dalsi:=Cuprex^.HlavniBod;
   If NovyBod^.Dalsi <> nil then NovyBod^.Dalsi^.Predchozi:=NovyBod;
   NovyBod^.Predchozi:=nil;
   Cuprex^.HlavniBod:=NovyBod;
   Inc(Cuprex^.PocetBodu);
   Bod := NovyBod;
  end;
end;

Procedure VytvorSpojB (var Spoj : SpojPtr; Cuprex : CuprexPtr; Bod1, Bod2 : BodPtr);
var NovySpoj : SpojPtr;
begin
 If (Cuprex <> nil) AND (Bod1 <> nil) AND (Bod2 <> nil) then
  begin
   New(NovySpoj);
   NovySpoj^.Zacatek := Bod1; Inc(Bod1^.Stupen);
   NovySpoj^.Konec := Bod2; Inc(Bod2^.Stupen);
   NovySpoj^.Group := 0;
   NovySpoj^.Tloustka := 0;
   NovySpoj^.Dalsi := Cuprex^.HlavniSpoj;
   If NovySpoj^.Dalsi <> nil then NovySpoj^.Dalsi^.Predchozi := NovySpoj;
   NovySpoj^.Predchozi := nil;
   Cuprex^.HlavniSpoj:=NovySpoj;
   Spoj:=NovySpoj;
  end;
end;


Procedure VytvorCaruK(var Cara : CaraPtr; var Obrys : ObrysPtr; X, Y : Sour);
var NovaCara, Posledni : CaraPtr;
begin
 If Obrys <> nil then
  begin
   New(NovaCara);
   NovaCara^.Xofs:=X;
   NovaCara^.Yofs:=Y;
   NovaCara^.Master:=Obrys;
   NovaCara^.Dalsi:=NovaCara;
   Posledni:=Obrys^.HlavniCara; {Najit posledni}
   While (Posledni <> nil) AND (Posledni^.Dalsi <> Obrys^.HlavniCara) do Posledni:=Posledni^.Dalsi;
   If Posledni <> nil then {Pokud posledni existuje, provest prirazeni}
    begin
     Posledni^.Dalsi:=NovaCara;
     NovaCara^.Dalsi:=Obrys^.HlavniCara;
    end;
   Obrys^.HlavniCara:=NovaCara;
   Cara:=NovaCara;
  end else Cara:=nil;
end;

Procedure VytvorCaru(var Cara : CaraPtr; var Obrys : ObrysPtr; X, Y : Sour);
var NovaCara, Posledni : CaraPtr;
begin
 If Obrys <> nil then
  begin
   New(NovaCara);
   NovaCara^.Xofs:=X;
   NovaCara^.Yofs:=Y;
   NovaCara^.Master:=Obrys;
   NovaCara^.Predchozi:=nil;
   NovaCara^.Dalsi:=Obrys^.HlavniCara;
   If Obrys^.HlavniCara <> nil then Obrys^.HlavniCara^.Predchozi:=NovaCara;
   Obrys^.HlavniCara:=NovaCara;
  end else Cara:=nil;
end;


Procedure VytvorObrys(var Obrys : ObrysPtr; Cuprex : CuprexPtr; NadSkupina : SkupinaPtr);
var NovyObrys : ObrysPtr;
begin
 If Cuprex <> nil then
  begin
   New(NovyObrys);
   NovyObrys^.Xofs :=0;
   NovyObrys^.Yofs :=0;
   NovyObrys^.Master := NadSkupina;
   NovyObrys^.HlavniCara := nil;
   NovyObrys^.Dalsi := Cuprex^.HlavniObrys;
   Cuprex^.HlavniObrys := NovyObrys;
   Obrys := NovyObrys;
  end else Obrys := nil;
end;

Procedure VytvorPodSkupinu(var Skupina : SkupinaPtr; Cuprex : CuprexPtr; NadSkupina : SkupinaPtr);
var NovaSkupina : SkupinaPtr;
begin
 If Cuprex <> nil then
  begin
   New(NovaSkupina);
   NovaSkupina^.Xofs := 0;
   NovaSkupina^.Yofs := 0;
   NovaSkupina^.Nazev := 'Nova skupina';
   NovaSkupina^.Attr := 0;
   NovaSkupina^.MasterCuprex := AktualniCuprex;
   NovaSkupina^.Master := NadSkupina;
   NovaSkupina^.Sub := nil;
   NovaSkupina^.Predchozi := nil;
   If NadSkupina <> nil then
    begin
     NovaSkupina^.Dalsi:=NadSkupina^.Sub;
     NadSkupina^.Sub:=NovaSkupina;
     If NovaSkupina^.Dalsi <> nil then NovaSkupina^.Dalsi^.Predchozi:=NovaSkupina;
    end else
    begin
     NovaSkupina^.Dalsi := Cuprex^.HlavniSkupina;
     If Cuprex^.HlavniSkupina <> nil then Cuprex^.HlavniSkupina^.Predchozi:=NovaSkupina;
     Cuprex^.HlavniSkupina:=NovaSkupina;
    end;
   Skupina := NovaSkupina;
  end else Skupina := nil;
end;

Procedure VytvorCuprex(var Cuprex : CuprexPtr);
var Novy : CuprexPtr;
begin
 New(Novy);
 Novy^.Nazev := 'NONAME';
 Novy^.Soubor := 'NOVY.'+Pripona;
 Novy^.PocetBodu := 0;
 Novy^.PocetSpoju := 0;
 Novy^.HlavniSpoj := nil;
 Novy^.HlavniBod := nil;
 Novy^.HlavniSkupina := nil;
 Novy^.HlavniObrys := nil;
 Novy^.Dalsi := HlavniCuprex;
 If Novy^.Dalsi <> nil then Novy^.Dalsi^.Predchozi := Novy;
 Novy^.Predchozi := nil;
 HlavniCuprex:=Novy;
 Cuprex:=Novy;
end;

Procedure ZrusBod(var Bod : BodPtr; Cuprex : CuprexPtr);
var Predchozi, Dalsi : BodPtr;
begin
 If Bod <> nil then
  begin
   Dalsi:=Bod^.Dalsi;
   Predchozi:=Bod^.Predchozi;
   Dispose(Bod); Bod:=nil; Dec(Cuprex^.PocetBodu);
   If Dalsi<>nil then Dalsi^.Predchozi:=Predchozi;
   If Predchozi<>nil then Predchozi^.Dalsi:=Dalsi else Cuprex^.HlavniBod:=Dalsi;
  end;
end;

Procedure ZrusPrazdneBody(Cuprex : CuprexPtr);
var TempBod, Dalsi : BodPtr;
begin
 TempBod:=Cuprex^.HlavniBod; SetColor(10);
 While TempBod <> nil do
  begin
   Dalsi := TempBod^.Dalsi;
   If TempBod^.Stupen = 0 then ZrusBod(TempBod,Cuprex);
   TempBod := Dalsi;
  end;
end;

Procedure ZrusSpoj(var Spoj : SpojPtr; Cuprex : CuprexPtr);
var Predchozi, Dalsi : SpojPtr;
begin
 If Spoj <> nil then
  begin
   Dalsi:=Spoj^.Dalsi;
   Predchozi:=Spoj^.Predchozi;
   Spoj^.Zacatek^.Stupen:=Spoj^.Zacatek^.Stupen-1;
   Spoj^.Konec^.Stupen:=Spoj^.Konec^.Stupen-1;
   Dispose(Spoj); Spoj:=nil;
   If Dalsi<>nil then Dalsi^.Predchozi:=Predchozi;
   If Predchozi<>nil then Predchozi^.Dalsi:=Dalsi else Cuprex^.HlavniSpoj:=Dalsi;
  end;
end;
(*
Procedure ZrusCuprex(var Cuprex : CuprexPtr);
var TempCuprex, Dalsi : CuprexPtr;
begin
 If Cuprex <> nil then
  begin
   {Zruseni spoju} ZrusVsechnySpoje(Cuprex^.HlavniSpoj);
   {Zruseni bodu}  ZrusVsechnyBody(Cuprex^.HlavniBod);
   {Zruseni obrysu}ZrusVsechnyObrysy(Cuprex^.HlavniObrys);
   {Zruseni skupin}ZrusVsechnySkupiny(Cuprex^.HlavniSkupina);
   Dalsi:=Cuprex^.Dalsi;
   If Cuprex = HlavniCuprex then HlavniCuprex := Dalsi;
   TempCuprex:=HlavniCuprex;
   While (TempCuprex <> nil) AND (TempCuprex^.Dalsi = Cuprex) do TempCuprex:=TempCuprex^.Dalsi;
   TempCuprex^.Dalsi := Dalsi;
   Dispose(Cuprex); Cuprex:=nil;
  end;
end;
*)
Procedure RozdelSpoj(var Spoj : SpojPtr; Cuprex : CuprexPtr; Skupina : SkupinaPtr; Xp, Yp : Integer);
var Zacatek, Stred, Konec : BodPtr;
    X, Y, X0, Y0, Xt, Yt, ux, uy : Sour;
    t : Real;
    Spoj1, Spoj2 : SpojPtr;
begin
 If Spoj <> nil then
  begin
   Zacatek := Spoj^.Zacatek;
   Konec := Spoj^.Konec;
   X:=PohledNaSourX(Xp);
   Y:=PohledNaSourY(Yp);
   X0:=Zacatek^.X;
   Y0:=Zacatek^.Y;
   ux:=Konec^.X - Zacatek^.X;
   uy:=Konec^.Y - Zacatek^.Y;
   If ux+uy <> 0 then
    begin
     t:=(-1)*(ux*(X0-X)+uy*(Y0-Y))/(ux*ux+uy*uy);
     If T>1 then T:=1;
     If T<0 then T:=0;
     Xt:=X0+Round(ux*t);
     Yt:=Y0+Round(uy*t);
    end;
   ZrusSpoj(Spoj,Cuprex);
   VytvorBod(Stred, Cuprex, Skupina, Xt, Yt, 0);
   VytvorSpojB(Spoj1, Cuprex, Zacatek, Stred);
   VytvorSpojB(Spoj2, Cuprex, Stred, Konec);
  end;
end;

Procedure ZrusVsechnyBody(var Bod : BodPtr);
var Dalsi : BodPtr;
    Ma : Longint;
begin
 While Bod <> nil do
  begin
   Dalsi := Bod^.Dalsi;
   Write('    Rusim bod:  X=',Bod^.X : 2,' Y=',Bod^.Y : 2);
   Write(', vel.',SizeOf(TBod)); Ma:=MemAvail;
   Dispose(Bod); Bod:=nil;
   WriteLn(', uvolneno: ',MemAvail-Ma);
{   Dec(Cuprex^.PocetBodu);}
   Bod := Dalsi;
  end;
end;

Procedure ZrusVsechnySpoje(var Spoj : SpojPtr);
var Dalsi : SpojPtr;
    Ma : Longint;
begin
 While Spoj <> nil do
  begin
   Dalsi := Spoj^.Dalsi;
   Write('---  Rusim spoj  (',Spoj^.Zacatek^.X : 2,',',Spoj^.Zacatek^.Y : 2,
                        ')-(',Spoj^.Konec^.X : 2,',',Spoj^.Konec^.Y : 2,')');
   Write(', vel.',SizeOf(TSpoj)); Ma:=MemAvail;
   Dispose(Spoj); Spoj:=nil;
   WriteLn(', uvolneno: ',MemAvail-Ma);
   Spoj := Dalsi;
  end;
end;

Procedure ZrusVsechnySkupiny(var Skupina : SkupinaPtr);
var Dalsi : SkupinaPtr;
    Ma : Longint;
begin
 While Skupina <> nil do
  begin
   Dalsi:=Skupina^.Dalsi;
   WriteLn(' {.}  Rusim skupinu: ',Skupina^.Nazev,', velikost ',SizeOf(TSkupina));
   Ma := MemAvail;
   ZrusVsechnySkupiny(Skupina^.Sub);
   Dispose(Skupina); Skupina:=nil;
   Skupina:=Dalsi;
   WriteLn(', uvolneno: ',MemAvail-Ma);
  end;
end;

Procedure ZrusVsechnyCary(var Cara : CaraPtr);
var Dalsi : CaraPtr;
begin
 If Cara <> nil then
  begin
   While Cara <> nil do
    begin
     Dalsi:=Cara^.Dalsi;
     Dispose(Cara); Cara:=nil;
     Cara:=Dalsi;
    end;
  end else WriteLn('      V rusenem obrysu neni zadna cara.');
end;

Procedure ZrusVsechnyObrysy(Obrys : ObrysPtr);
var Dalsi : ObrysPtr;
    Ma : Longint;
begin
 While Obrys <> nil do
  begin
   Dalsi := Obrys^.Dalsi;
   Write('[ ]  Rusim obrys skupiny: ',Obrys^.Master^.Nazev);
   WriteLn(', velikost ',SizeOf(TObrys)); Ma:=MemAvail;
   ZrusVsechnyCary(Obrys^.HlavniCara);
   Dispose(Obrys); Obrys:=nil;
   Obrys := Dalsi;
   WriteLn('     Obrys zrusen, uvolneno: ',MemAvail-Ma);
  end;
end;

Procedure ZrusVsechnyCuprexy;
var Dalsi : CuprexPtr;
    Ma : Longint;
begin
 While HlavniCuprex <> nil do
  begin
   Dalsi := HlavniCuprex^.Dalsi;
   WriteLn('  Rusim cuprex: ',HlavniCuprex^.Nazev,', velikost ',SizeOf(TCuprex)); Ma:=MemAvail;
   {Zruseni spoju} ZrusVsechnySpoje(HlavniCuprex^.HlavniSpoj);
   {Zruseni bodu}  ZrusVsechnyBody(HlavniCuprex^.HlavniBod);
   {Zruseni obrysu}ZrusVsechnyObrysy(HlavniCuprex^.HlavniObrys);
   {Zruseni skupin}ZrusVsechnySkupiny(HlavniCuprex^.HlavniSkupina);
   Dispose(HlavniCuprex); HlavniCuprex:=nil;
   WriteLn('Cuprex zrusen, uvolneno: ',MemAvail-Ma);
   HlavniCuprex := Dalsi;
  end;
end;


Procedure UlozCuprex(Cuprex : CuprexPtr);

 Procedure ZapisObrys(var T : Text; Cara : CaraPtr; Mezery : String);
  var TempCara : CaraPtr;
  begin
   WriteLn(T,Mezery,'<',ElObrys,'>');
   TempCara:=Cara;
   While TempCara <> nil do
    begin
     Write(T,Mezery,Cara^.Xofs,',',Cara^.Yofs);
     If TempCara^.Dalsi = nil then WriteLn(T,';') else Write(T,';');
     TempCara:=TempCara^.Dalsi;
    end;
   WriteLn(T,Mezery,'<',ElClose,ElObrys,'>');
  end;

 Procedure ZapisObrysy(var T : Text; Cuprex : CuprexPtr; Skupina : SkupinaPtr; Mezery : String);
  var TempObrys : ObrysPtr;
  begin
   TempObrys:=Cuprex^.HlavniObrys;
   While TempObrys <> nil do
    begin
     If TempObrys^.Master = Skupina then ZapisObrys(T,TempObrys^.HlavniCara,Mezery+' ');
     TempObrys:=TempObrys^.Dalsi;
    end;
  end;

 Procedure ZapisNazev(var T : Text; Nazev : TNazev; Mezery : String);
  begin
   Write(T,Mezery,'<',ElNazev,'>'); Write(T,Nazev); WriteLn(T,'<',ElClose,ElNazev,'>');
  end;

 Procedure ZapisVsechnySpoje(var T : Text; Cuprex : CuprexPtr; Mezery : String);
  var TempSpoj : SpojPtr;
  begin
   If Cuprex <> nil then
    begin
     WriteLn(T,Mezery,'<',ElSpoje,'>');
     TempSpoj:=Cuprex^.HlavniSpoj;
     While TempSpoj <> nil do
      begin
       WriteLn(T,Mezery+' ',TempSpoj^.Zacatek^.Index,':',TempSpoj^.Konec^.Index,';');
       TempSpoj := TempSpoj^.Dalsi;
      end;
     WriteLn(T,Mezery,'<',ElClose,ElSpoje,'>');
    end;
  end;

 Procedure ZapisVsechnyBody(var T : Text; Cuprex : CuprexPtr; Skupina : SkupinaPtr; Mezery : String);
  var TempBod : BodPtr;
  begin
   If Cuprex <> nil then
    begin
     WriteLn(T,Mezery,'<',ElBody,'>');
     TempBod:=Cuprex^.HlavniBod;
     While TempBod <> nil do
      begin
       If TempBod^.Master = Skupina then
        WriteLn(T,Mezery+' ',TempBod^.Index,':',SourNaStr(TempBod^.X),',',SourNaStr(TempBod^.Y),';');
       TempBod := TempBod^.Dalsi;
      end;
     WriteLn(T,Mezery,'<',ElClose,ElBody,'>');
    end;
  end;

 Procedure ZapisVsechnySkupiny(var T : Text; Cuprex : CuprexPtr; Skupina : SkupinaPtr; Mezery : String);
  begin
   While Skupina <> nil do
    begin
     WriteLn(T,Mezery,'<',elSkupina,'>');
      ZapisNazev(T, Skupina^.Nazev, Mezery + ' ');
      ZapisVsechnyBody(T, Cuprex, Skupina, Mezery + ' ');
      ZapisObrysy(T, Cuprex, Skupina, Mezery + ' ');
      ZapisVsechnySkupiny(T, Cuprex, Skupina^.Sub, Mezery + ' ');
     WriteLn(T,Mezery,'<',elClose,elSkupina,'>');
     Skupina:=Skupina^.Dalsi;
    end;
  end;

 Procedure OcislujBody(Cuprex : CuprexPtr);
  var TempBod : BodPtr;
      Index : Word;
  begin
   If Cuprex <> nil then
    begin
     TempBod:=Cuprex^.HlavniBod;
     Index:=1;
     While TempBod <> nil do
      begin
       TempBod^.Index:=Index;
       Inc(Index);
       TempBod:=TempBod^.Dalsi;
      end;
    end;
  end;

var T : Text;
begin
 If Cuprex <> nil then
  begin
   OcislujBody(Cuprex);
   Assign(T,Cuprex^.Soubor);
   ReWrite(T);
    WriteLn('@#40');
    WriteLn(T,'<',ElCuprex,'>');
     ZapisNazev(T,Cuprex^.Nazev,' ');
     ZapisVsechnySkupiny(T,Cuprex,Cuprex^.HlavniSkupina,' ');
     ZapisVsechnySpoje(T,Cuprex,' ');
    WriteLn(T,'<',ElClose,ElCuprex,'>');
   Close(T);
  end;
end;

Procedure UlozCuprexJako(Cuprex : CuprexPtr);
var Soubor : String;
    K, Kf : Char;
    I : Byte;
begin
 If Cuprex <> nil then
  begin
   SetColor(7);
   Bar(MinX,355+1,MaxX,370-1);
   Soubor:=Cuprex^.Soubor;
   Repeat
     OutTextXY(10,360,' Ulozit jako: '+Soubor);
     If KeyPressed then K:=ReadKey else K:=#255;
      If K = #0 then Kf:=ReadKey else Kf:=#255;
     Case K of
      'A'..'Z','a'..'z','0'..'9','.','_':If Length(Soubor) < 12 then Soubor:=Soubor + K;
      #8:begin
          If Length(Soubor) > 0 then Soubor:=Copy(Soubor,1,Length(Soubor)-1);
          Bar(MinX,355+1,MaxX,370-1);
         end;
     end;
   Until (K=KlEnter) OR (K=KlEsc);
   If K = KlEnter then
    begin
     I:=1;
     While (Soubor[I] <> '.') AND (I <= Length(Soubor)) do Inc(I);
     If (Soubor[I] <> '.') AND (Length(Soubor) < 9) then Soubor:=Soubor+Pripona;
     Cuprex^.Soubor:=Soubor;
     UlozCuprex(Cuprex);
    end;
  end;
end;


Procedure NactiCuprex(Soubor : String);
const KodEOF = 1; KodObsah = 2; KodElement = 3; KodZavritElement = 4;
      PovoleneZnaky = ['0'..'9','A'..'Z','a'..'z',' '..'/',':','=','?'];
      Oddelovace = [';','='];

var T : Text;
    R : Char;
    PosledniCuprex : CuprexPtr;
    PosledniSkupina, PosledniNadSkupina : SkupinaPtr;
    PosledniObrys : ObrysPtr;
    PosledniBod : BodPtr;
    PosledniSpoj : SpojPtr;
    PosledniCara : CaraPtr;
    PosledniNazev : ^TNazev;

 {Procedury k uprave ziskanych dat}
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0;
   While (Zaznam[I+Cnt] IN KtereZnaky) AND (I+Cnt <= Ord(Zaznam[0])) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;

 Procedure ZpracujBod(Zaznam : String);
 var I,Cnt:Byte;
     Index:Word;
     X,Y:Sour;
     ValCode:Integer;
 begin
  I:=1; Cnt:=0;
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Index, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), X, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), Y, ValCode);
  VytvorBod(PosledniBod,PosledniCuprex,PosledniSkupina, X, Y, Index);
 end;

 Procedure ZpracujSpoj(Zaznam : String);
 var I,Cnt:Byte;
     Index1, Index2:Word;
     ValCode:Integer;
     Bod1, Bod2:BodPtr;
 begin
  I:=1; Cnt:=0;  { 1-4 }
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Index1, ValCode);
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Index2, ValCode);
  HledejBodIndex(Bod1,PosledniCuprex,Index1);
  HledejBodIndex(Bod2,PosledniCuprex,Index2);
  VytvorSpojB(PosledniSpoj,PosledniCuprex,Bod1,Bod2);
 end;

 Procedure ZpracujObrys(Zaznam : String);
 var I,Cnt:Byte;
     X,Y:Sour;
     ValCode:Integer;
 begin       {Celek: 90.0,-74.0;103.0,-1.0;122.0,-69.0;116.0,-6.0;127.0,-57.0; }
  I:=1; Cnt:=0;  { 90.0,-74.0 }
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), X, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), Y, ValCode);
  VytvorCaru(PosledniCara,PosledniObrys,X,Y);
{  WriteLn('Nova cara do posledniho obrysu: X=',X,', Y=',Y);}
 end;

 Procedure ZpracujNazev(Zaznam : String);
 begin
  PosledniNazev^:=Zaznam;
 end;

 {Procedury ke cteni ze souboru}
 Procedure PrectiSlovo(var Slovo : String; var Kod : Byte);
  var R : Char;
  begin
   Slovo := '';
   Repeat Read(T,R); Until (R IN PovoleneZnaky + ['<','>',';'] - [' ']) OR Eof(T);
   While NOT ((R IN ['<','>'] + Oddelovace) OR Eof(T)) do
    begin
     If R IN PovoleneZnaky then Slovo := Slovo + R;
     Read(T,R);
    end;
   If (R = '<') OR (R IN Oddelovace) then Kod := KodObsah;
   If (R = '>') then Kod := KodElement;
   If Slovo = '' then Kod := 0;
   If Eof(T) then Kod := KodEof;
  end;

 Procedure ZpracujObsah(Element, Zaznam : String);
 begin
  If Element = ElNazev then ZpracujNazev(Zaznam);
  If Element = ElBody then ZpracujBod(Zaznam);
  If Element = ElSpoje then ZpracujSpoj(Zaznam);
  If Element = ElObrys then ZpracujObrys(Zaznam);
 end;

 Procedure DalsiZaznam(OtevrenyElement : String);
  var Slovo : String;
      Kod : Byte;
  begin
   Repeat
    PrectiSlovo(Slovo, Kod);
    If Kod = KodObsah then ZpracujObsah(OtevrenyElement,Slovo);
    If Kod = KodElement then
      If Slovo = ElClose + OtevrenyElement then Kod := KodZavritElement else
       begin
        If Slovo = ElCuprex then
         begin
          VytvorCuprex(PosledniCuprex);
          PosledniCuprex^.Soubor:=Soubor;
          PosledniSkupina:=nil;
          PosledniNadSkupina:=nil;
          PosledniNazev:=@PosledniCuprex^.Nazev;
         end;
        If Slovo = ElSkupina then
         begin {Vytvoreni podskupiny na skupine}
          PosledniNadSkupina := PosledniSkupina;
          VytvorPodSkupinu(PosledniSkupina, PosledniCuprex, PosledniNadSkupina);
          If PosledniSkupina <> nil then PosledniNazev:=@PosledniSkupina^.Nazev;
         end;
        If Slovo = ElObrys then
         begin
          VytvorObrys(PosledniObrys, PosledniCuprex, PosledniSkupina);
         end;
        DalsiZaznam(Slovo);
        If Slovo = ElSkupina then
         begin
          PosledniSkupina:=PosledniNadSkupina;
          If PosledniNadSkupina <> nil then PosledniNadSkupina:=PosledniNadSkupina^.Master;
         end;
{        If Slovo = ElObrys then WriteLn('Uzaviram novy obrys na posledni skupine.');}
      end;
   Until (Kod = KodEof) OR (Kod = KodZavritElement);
  end;

var Kod : Byte;
    Slovo : string;
Begin
 PosledniCuprex:=nil;
 PosledniSkupina:=nil;
 PosledniNadSkupina:=nil;
 PosledniObrys:=nil;
 PosledniCara:=nil;
 Assign(T,Soubor);
 Reset(T);
  DalsiZaznam('');
 Close(T);
 AktualniCuprex:=PosledniCuprex;
 AktualniSkupina:=PosledniCuprex^.HlavniSkupina;
end;

Procedure WriteXY(Y : Integer; Color : Byte; S : String);
begin
{ Bar(MinX+10,MinY+Y*10,MinX+120,MinY+Y*10+10);}
 SetColor(Color);
 OutTextXY(MinX+10,MinY+Y*10+2,S);
end;

Procedure VyberSoubor;
  type SouborPtr = ^Soubor;
          Soubor = record
                    DirInfo : SearchRec;
                    Dalsi, Predchozi : SouborPtr;
                   end;
  const Vyska = 30;
  var Seznam : SouborPtr;
      ZacatekVypisu, KonecVypisu, Pozice : SouborPtr;
      DirInfo: SearchRec;

 procedure PridejSoubor(DirInfo : SearchRec);
  var NovySoubor : SouborPtr;
  begin
   New(NovySoubor);
   NovySoubor^.DirInfo:=DirInfo;
   NovySoubor^.Predchozi:=nil;
   NovySoubor^.Dalsi := Seznam;
   If Seznam <> nil then Seznam^.Predchozi:=NovySoubor;
   Seznam:=NovySoubor;
  end;

 procedure NastavKonecVypisu;
  var Y : Byte;
  begin
   KonecVypisu:=ZacatekVypisu;
   Y:=0;
   If KonecVypisu <> nil then
    While (KonecVypisu^.Dalsi <> nil) AND (Y < Vyska) do
     begin
      Inc(Y);
      KonecVypisu:=KonecVypisu^.Dalsi;
     end;
  end;

 procedure VypisSoubory;
  var TempSoubor : SouborPtr;
            Y, C : Byte;
  begin
   NastavKonecVypisu;
   TempSoubor:=ZacatekVypisu;
   Y:=1;
   If TempSoubor = nil then WriteXY(1,7,'Nebyly nalezeny zadne soubory');
   While (TempSoubor <> nil) AND (TempSoubor^.Predchozi <> KonecVypisu) do
    begin
     If TempSoubor = Pozice then C:= 14 else C:= 7;
     WriteXY(Y, C, TempSoubor^.DirInfo.Name + '        ');
     TempSoubor:=TempSoubor^.Dalsi;
     Inc(Y);
    end;
  end;

 procedure ZrusitSeznam;
 var Dalsi : SouborPtr;
  begin
   While Seznam <> nil do
    begin
     Dalsi := Seznam^.Dalsi;
     Dispose(Seznam); Seznam:=nil;
     Seznam := Dalsi;
    end;
  end;

 var K, Kf : Char;

begin
  Seznam:=nil;
  FindFirst('*.'+Pripona, Archive, DirInfo);
  While DosError = 0 do
  begin
   PridejSoubor(DirInfo);
   FindNext(DirInfo);
  end;
  ZacatekVypisu:=Seznam;
  Pozice:=ZacatekVypisu;
  VypisSoubory;
  Repeat
   If KeyPressed then K:=ReadKey else K:=#255;
    If K = #0 then Kf:=ReadKey else Kf:=#255;
   Case Kf of
    KlfNahoru: If (Pozice <> nil) AND (Pozice^.Predchozi <> nil) then
              begin
               If (Pozice = ZacatekVypisu) AND (ZacatekVypisu^.Predchozi <> nil)
                 then ZacatekVypisu:=ZacatekVypisu^.Predchozi;
               Pozice := Pozice^.Predchozi;
               VypisSoubory;
              end;
    KlfDolu: If (Pozice <> nil) AND (Pozice^.Dalsi <> nil) then
              begin
               If (Pozice = KonecVypisu) AND (KonecVypisu^.Dalsi <> nil)
                 then ZacatekVypisu:=ZacatekVypisu^.Dalsi;
               Pozice := Pozice^.Dalsi;
               VypisSoubory;
              end;
   end;
  Until (K = KlEsc) OR (K = KlEnter);
 If (K = KlEnter) AND (Pozice <> nil) then NactiCuprex(Pozice^.DirInfo.Name);
 ZrusitSeznam;
end;


{SupixRefender homerk sibol khardi uvel knora lepist fjorta.}
Procedure GroupManager(Cuprex : CuprexPtr);
 const Vyska = 10;
 var ZacatekVypisu, KonecVypisu, Pozice : SkupinaPtr;

 procedure NastavVnoreniSkupin;
  procedure NastavVnoreniPodSkupin(Polozka : SkupinaPtr; Vnoreni : Byte);
   begin
    While Polozka <> nil do
     begin
      Polozka^.Vnoreni:=Vnoreni;
      If Polozka^.Sub <> nil then NastavVnoreniPodSkupin(Polozka^.Sub, Vnoreni + 1);
      Polozka:=Polozka^.Dalsi;
     end;
   end;
 begin
  NastavVnoreniPodSkupin(Cuprex^.HlavniSkupina, 1);
 end;

 procedure VypisPolozku(Polozka : SkupinaPtr; var Y : Byte);
  var C, Tmp : Byte;
      R : Char;
      Mezery : string;
  begin
     Mezery:='';
     If Polozka^.Attr AND SaZamcena = SaZamcena then C:= 1 else C:= 7;
     If Polozka = KonecVypisu then C:= 4;
     If Polozka = ZacatekVypisu then C:= 2;
     If Polozka^.Attr AND SaOznacena = SaOznacena then C:= 6;
     If Polozka = Pozice then C:= C + 8; {barva vybrane polozky}
     If Polozka^.Sub <> nil then if Polozka^.Attr AND SaRozbalena = SaRozbalena then R:='-' else R:='+' else R:=' ';
     For Tmp:=0 to Polozka^.Vnoreni do Mezery:=Mezery+' ';
     WriteXY(Y, C, Mezery + R + Polozka^.Nazev);
     Inc(Y); {posun na dalsi radek}
  end;

 procedure ZalezUplneDolu (Polozka : SkupinaPtr; var Vysledek : SkupinaPtr);
 begin
  If Polozka <> nil then
   begin
    While Polozka^.Dalsi <> nil do Polozka:=Polozka^.Dalsi;
    If Polozka^.Attr AND SaRozbalena = SaRozbalena then ZalezUplneDolu(Polozka^.Sub, Polozka);
    Vysledek:=Polozka;
   end;
 end;

 procedure VylezNahoru (Polozka : SkupinaPtr; var Vysledek : SkupinaPtr);
  begin
   If (Polozka <> nil) then
    If (Polozka^.Dalsi = nil) then
      begin
       While Polozka^.Predchozi <> nil do Polozka:=Polozka^.Predchozi;
       VylezNahoru(Polozka^.Master, Vysledek);
      end else Vysledek:=Polozka;
  end;

 function KrokDolu(var Polozka : SkupinaPtr) : Boolean;
  var OldPolozka : SkupinaPtr;
  begin
   OldPolozka := Polozka;
   If (Polozka^.Sub <> nil) AND (Polozka^.Attr AND saRozbalena = saRozbalena) then
    Polozka:=Polozka^.Sub
    else If Polozka^.Dalsi <> nil then
      Polozka:=Polozka^.Dalsi
      else
       begin
        VylezNahoru(Polozka,Polozka);
        If Polozka^.Dalsi <> nil then Polozka:=Polozka^.Dalsi;
       end;
   If OldPolozka <> Polozka then KrokDolu:=TRUE else KrokDolu:=FALSE;
  end;

 function KrokNahoru(var Polozka : SkupinaPtr) : Boolean;
  var OldPolozka : SkupinaPtr;
  begin
   OldPolozka := Polozka;
   If Polozka^.Predchozi <> nil then
    begin
     Polozka:=Polozka^.Predchozi;
     If (Polozka^.Sub <> nil) AND (Polozka^.Attr AND saRozbalena = saRozbalena) then
       ZalezUplneDolu(Polozka^.Sub,Polozka);
    end
    else If Polozka^.Master <> nil then Polozka:=Polozka^.Master;
   If OldPolozka <> Polozka then KrokNahoru:=TRUE else KrokNahoru:=FALSE;
  end;

 function RozbalStrom(var Polozka : SkupinaPtr) : Boolean;
 begin
  If (Polozka^.Sub <> nil) AND (Polozka^.Attr AND saRozbalena <> saRozbalena) then
   begin
    Polozka^.Attr := Polozka^.Attr OR SaRozbalena;
    RozbalStrom:=TRUE;
   end else RozbalStrom:=FALSE;
 end;

 function ZabalStrom(var Polozka : SkupinaPtr) : Boolean;
 begin
  If Polozka^.Attr AND saRozbalena = saRozbalena then
   begin
    Polozka^.Attr := Polozka^.Attr AND NOT SaRozbalena;
    ZabalStrom:=TRUE;
   end else ZabalStrom:=FALSE;
 end;

 procedure NastavZacatekVypisu;
  var Y, Sub : Byte;
  begin
   ZacatekVypisu:=KonecVypisu;
   For Y:=1 to Vyska do KrokNahoru(ZacatekVypisu);
  end;

 procedure NastavKonecVypisu;
  var Y, Sub : Byte;
  begin
   KonecVypisu:=ZacatekVypisu;
   For Y:=1 to Vyska do KrokDolu(KonecVypisu);
  end;

 procedure VypisSeznam(var Smazat : Boolean);
  var Vypis : SkupinaPtr;
      Y : Byte;
      Mezery : String;
  begin
   If Smazat then begin SetFillStyle(1,0); Bar(MinX,MinY,MaxX,MaxY); Smazat:=FALSE; end;
   If ZacatekVypisu = nil then WriteXY(1,7,'V aktualnim cuprexu nejsou zadne skupiny');
   Vypis:=ZacatekVypisu;
   Mezery:=''; Y:=0;
   While (Vypis <> nil) AND (Vypis <> KonecVypisu) do
    begin
     VypisPolozku(Vypis, Y);
     KrokDolu(Vypis);
    end;
   If Vypis = KonecVypisu then VypisPolozku(Vypis, Y);
  end;
{jeste to chce vyresit pripad, kdy v cuprexu neni zadna polozka}
var K, Kf : Char;
    Refresh : Boolean;
begin
 If Cuprex <> nil then ZacatekVypisu:=Cuprex^.HlavniSkupina else ZacatekVypisu:=nil;
  If ZacatekVypisu = nil then Write(#7);
  Pozice:=ZacatekVypisu;
  NastavKonecVypisu; Refresh:=TRUE;
  NastavVnoreniSkupin;
  Repeat
   VypisSeznam(Refresh);
   If KeyPressed then K:=ReadKey else K:=#255;
    If K = #0 then Kf:=ReadKey else Kf:=#255;
   Case K of
    ' ': Pozice^.Attr := Pozice^.Attr XOR SaZamcena;
   end;
   Case Kf of
    KlfNahoru: begin
                If Pozice = ZacatekVypisu then Refresh:=KrokNahoru(ZacatekVypisu);
                KrokNahoru(Pozice);
                NastavKonecVypisu;
               end;
      KlfDolu: begin
                If Pozice = KonecVypisu then Refresh:=KrokDolu(KonecVypisu);
                KrokDolu(Pozice);
                NastavZacatekVypisu;
               end;
    KlfVpravo: begin
                Refresh:=RozbalStrom(Pozice);
                NastavKonecVypisu;
               end;
     KlfVlevo: begin
                Refresh:=ZabalStrom(Pozice);
                NastavKonecVypisu;
               end;
       KlfIns: Pozice^.Attr := Pozice^.Attr XOR SaOznacena;
   end;
  Until (K = KlEsc) OR (K = KlEnter);
 If (K = KlEnter) AND (Pozice <> nil) then AktualniSkupina:=Pozice;
 SetFillStyle(1,0);
 Bar(MinX,MinY,MaxX,MaxY);
end;


Procedure NastavAktualniUkazatele(Cuprex : CuprexPtr);
begin
 AktualniCuprex:=Cuprex;
 If Cuprex <> nil then AktualniSkupina:=Cuprex^.HlavniSkupina else AktualniSkupina:=nil;
 If Cuprex <> nil then AktualniBod:=Cuprex^.HlavniBod else AktualniBod:=nil;
 If Cuprex <> nil then AktualniSpoj:=Cuprex^.HlavniSpoj else AktualniSpoj:=nil;
end;

Procedure LineScaled(X1, Y1, X2, Y2 : Sour);
 procedure HledejPrusecik(Xh0,Yh0,Xh,Yh : Sour; var Px, Py : Sour);
 var t:Real;
    uhx, uhy, ux, uy : Sour;
 begin
  uhx:=Xh-Xh0; uhy:=Yh-Yh0;
  ux:=X2-X1;   uy:=Y2-Y1;
  If (uhy * ux  -  uhx * uy) <> 0 then
    t:=(uhx * (Y1-Yh0)  -  uhy * (X1-Xh0)) / (uhy * ux  -  uhx * uy) else t:=2;
  If (t >= 0) AND (t <= 1) then {Prusecik je na care}
   begin
    Px:=Round(X1+t*ux);
    Py:=Round(Y1+t*uy);
   end;
 end;
begin
 X1:=SourNaPohled(X1,Editor.Pohled.Xpos,Editor.Pohled.Xmed);
 X2:=SourNaPohled(X2,Editor.Pohled.Xpos,Editor.Pohled.Xmed);
 Y1:=SourNaPohled(Y1,Editor.Pohled.Ypos,Editor.Pohled.Ymed);
 Y2:=SourNaPohled(Y2,Editor.Pohled.Ypos,Editor.Pohled.Ymed);
{prusecik s hornim okrajem}
 If Y1 < MinY then HledejPrusecik(MinX,MinY,MaxX,MinY,X1,Y1);
 If Y2 < MinY then HledejPrusecik(MinX,MinY,MaxX,MinY,X2,Y2);
{prusecik s dolnim okrajem}
 If Y1 > MaxY then HledejPrusecik(MinX,MaxY,MaxX,MaxY,X1,Y1);
 If Y2 > MaxY then HledejPrusecik(MinX,MaxY,MaxX,MaxY,X2,Y2);
{prusecik s levym okrajem}
 If X1 < MinX then HledejPrusecik(MinX,MinY,MinX,MaxY,X1,Y1);
 If X2 < MinX then HledejPrusecik(MinX,MinY,MinX,MaxY,X2,Y2);
{prusecik s pravym okrajem}
 If X1 > MaxX then HledejPrusecik(MaxX,MinY,MaxX,MaxY,X1,Y1);
 If X2 > MaxX then HledejPrusecik(MaxX,MinY,MaxX,MaxY,X2,Y2);
{nakresleni cary po omezeni souradnic}
 If (X1 >= MinX) AND (X1 <= MaxX) AND (Y1 >= MinY) AND (Y1 <= MaxY) AND
    (X2 >= MinX) AND (X2 <= MaxX) AND (Y2 >= MinY) AND (Y2 <= MaxY) then
     Line(Round(X1),Round(Y1),Round(X2),Round(Y2));
end;

Procedure ZobrazujSpoje(Cuprex : CuprexPtr);
var TempSpoj : SpojPtr;
    X1, Y1, X2, Y2 : Sour;
begin
 If Cuprex <> nil then
  begin
   TempSpoj:=Cuprex^.HlavniSpoj; SetColor(15);
  { SetLineStyle(0, $FFFE, ThickWidth);}
   While TempSpoj <> nil do
    begin
     If TempSpoj = AktualniSpoj then
      begin
       If TempSpoj^.Group = 1 then SetColor(14) else SetColor(15)
      end
      else If TempSpoj = Cuprex^.HlavniSpoj then SetColor(12)
       else If TempSpoj^.Group = 1 then SetColor(6) else SetColor(7);
     LineScaled(TempSpoj^.Zacatek^.X,TempSpoj^.Zacatek^.Y,TempSpoj^.Konec^.X,TempSpoj^.Konec^.Y);
     TempSpoj := TempSpoj^.Dalsi;
    end;
  { SetLineStyle(0, $C3, NormWidth);}
  end;
end;

Procedure ZobrazujObrys(Obrys : ObrysPtr);
var Cara : CaraPtr;
begin
 If Obrys <> nil then
  If Obrys^.HlavniCara <> nil then
   begin
    Cara:=Obrys^.HlavniCara;
    While (Cara <> nil) AND (Cara^.Dalsi <> nil) do
     begin
      LineScaled(Cara^.Xofs,Cara^.Yofs,Cara^.Dalsi^.Xofs,Cara^.Dalsi^.Yofs);
      Cara:=Cara^.Dalsi;
     end;
    LineScaled(Cara^.Xofs,Cara^.Yofs,Obrys^.HlavniCara^.Xofs,Obrys^.HlavniCara^.Yofs);
   end;
end;

Procedure ZobrazujObrysy(Cuprex : CuprexPtr; Skupina : SkupinaPtr);
var Obrys : ObrysPtr;
begin
 If Cuprex <> nil then
  begin
   SetLineStyle(DashedLn, $FFFE, NormWidth);
   Obrys:=Cuprex^.HlavniObrys;
   While Obrys <> nil do
    begin
     If Obrys^.Master = Skupina then SetColor(11) else SetColor(1);
     ZobrazujObrys(Obrys);
     Obrys:=Obrys^.Dalsi;
    end;
   SetLineStyle(SolidLn, $FFFE, NormWidth);
  end;
end;

Procedure ZobrazujBod(Bod : BodPtr);
var X1, Y1, X2, Y2 : Longint;
    StupStr : String;
begin
 X1:=SourNaPohled(Bod^.X,Editor.Pohled.Xpos,Editor.Pohled.Xmed)-5;
 Y1:=SourNaPohled(Bod^.Y,Editor.Pohled.Ypos,Editor.Pohled.Ymed)-5;
 X2:=X1+10;
 Y2:=Y1+10;
 Str(Bod^.Stupen,StupStr);
 If (X1 >= MinX) AND (X1 <= MaxX) AND (Y1 >= MinY) AND (Y1 <= MaxY) AND
    (X2 >= MinX) AND (X2 <= MaxX) AND (Y2 >= MinY) AND (Y2 <= MaxY) then
    begin
     Rectangle(X1,Y1,X2,Y2);
     If (X2+10 <= MaxX) AND (Y2+10 <= MaxY) then OutTextXY(X2,Y2,StupStr);
  {   PieSlice(TempBod^.X,TempBod^.Y,0,360,TempBod^.Dira);}
  {   Circle(TempBod^.X,TempBod^.Y,TempBod^.Dira);}
    end;
end;

Procedure ZobrazujBody;
var TempBod : BodPtr;
begin
 If AktualniCuprex <> nil then
  begin
   TempBod:=AktualniCuprex^.HlavniBod; SetColor(10);
   While TempBod <> nil do
    begin
     If TempBod = AktualniBod then SetColor(10) else SetColor(2);
     Case Editor.PointMode of
      1 : If TempBod = AktualniBod then ZobrazujBod(TempBod);
      2 : ZobrazujBod(TempBod);
     end;
     TempBod := TempBod^.Dalsi;
    end;
  end;
end;

Procedure ZobrazujGrid;
var Xp, XM : Sour;
    Xpohl : Integer;
begin
 If Editor.Grid.On then
  begin
   SetColor(8);
   Xp:=Round(PohledNaSourX(MinX) / Editor.Grid.Modul) * Editor.Grid.Modul;
   XM:=PohledNaSourX(MaxX);
   While Xp < XM do
    begin
     Xpohl := SourNaPohled(Xp, Editor.Pohled.Xpos, Editor.Pohled.Xmed);
     If (Xpohl > MinX)AND(Xpohl < MaxX) then Line(Xpohl,MinY,Xpohl,MaxY);
     Xp:=Xp+Editor.Grid.Modul;
    end;
   Xp:=Round(PohledNaSourY(MinY) / Editor.Grid.Modul) * Editor.Grid.Modul;
   XM:=PohledNaSourY(MaxY);
   While Xp < XM do
    begin
     Xpohl := SourNaPohled(Xp, Editor.Pohled.Ypos, Editor.Pohled.Ymed);
     If (Xpohl > MinY)AND(Xpohl < MaxY) then Line(MinX,Xpohl,MaxX,Xpohl);
     Xp:=Xp+Editor.Grid.Modul;
    end;
  end;
end;

Procedure ZobrazujStredPohledu;
begin
 SetColor(7);
 Line(Editor.Pohled.Xmed-30,Editor.Pohled.Ymed,Editor.Pohled.Xmed-10,Editor.Pohled.Ymed);
 Line(Editor.Pohled.Xmed+10,Editor.Pohled.Ymed,Editor.Pohled.Xmed+30,Editor.Pohled.Ymed);
 Line(Editor.Pohled.Xmed,Editor.Pohled.Ymed-30,Editor.Pohled.Xmed,Editor.Pohled.Ymed-10);
 Line(Editor.Pohled.Xmed,Editor.Pohled.Ymed+10,Editor.Pohled.Xmed,Editor.Pohled.Ymed+30);
 Rectangle(MinX-1,MinY-1,MaxX+1,MaxY+1);
end;

Procedure PanelMenu(Info : String);
begin
 SetColor(7);
 SetFillStyle(1,6);
 Bar(MinX,355+1,MaxX,370-1);
 OutTextXY(10,360,Info);
end;

Procedure PanelEntity;
begin
 SetColor(7);
 Bar(MinX,370+1,MaxX,448-1);
 OutTextXY(10,381,' Aktualni soubor: '+AktualniCuprex^.Soubor+' ');
 OutTextXY(10,391,' Aktualni cuprex: '+AktualniCuprex^.Nazev+' ');
 OutTextXY(10,401,' Aktualni skupina: '+AktualniSkupina^.Nazev+' ');
end;

Procedure PanelMemInfo;
var obsstr, availstr : String;
begin
 SetColor(7);
 Str(MemAvail, availstr);
 Str(MaxAvMem-MemAvail, obsstr);
 OutTextXY(10,451,' V halde je obsazeno: '+obsstr+' B');
 OutTextXY(10,461,' V halde je volnych: '+availstr+' B');
end;

Procedure PanelSouradnice;
var Xst, Yst, Zv : String;
begin
 SetColor(7);
 Str(Editor.Pohled.Zvetseni, Zv);
 Str(PohledNaSourX(MouX):3:3,Xst);
 Str(PohledNaSourY(MouY):3:3,Yst);
 SetFillStyle(1,6); Bar(380,451,450,458); Bar(440,461,620,468);
 OutTextXY(300,451,' Zvetseni: '+Zv+' %');
 OutTextXY(300,461,' Souradnice mysi: '+Xst+','+Yst);
end;

Procedure ZobrazujPanel;
begin
 Rectangle(MinX-1,355,MaxX+1,470);
 Line(MinX-1,370,MaxX+1,370);
 Line(MinX-1,448,MaxX+1,448);
 SetFillStyle(1,6);
 Bar(MinX,448+1,MaxX,470-1);
 PanelMenu(' Castell software  Lukas Cerovsky (C) 2002, nabidku vyvolate klavesou Esc');
 PanelEntity; PanelMemInfo; PanelSouradnice;
end;

Procedure PrekreslitPohled;
begin
 HidePointer;
 SetFillStyle(1,0);
 Bar(MinX,MinY,MaxX,MaxY);
 ZobrazujGrid;
 ZobrazujObrysy(AktualniCuprex, AktualniSkupina);
 ZobrazujSpoje(AktualniCuprex);
 ZobrazujBody;
 ZobrazujStredPohledu;
 ShowPointer;
end;

Procedure PriblizitPohled;
begin
{ Editor.Pohled.KrokZvetseni:=Editor.Pohled.Zvetseni div 10;}
 If Editor.Pohled.Zvetseni < MaxZvetseni - Editor.Pohled.KrokZvetseni then
 Editor.Pohled.Zvetseni:=Editor.Pohled.Zvetseni + Editor.Pohled.KrokZvetseni;
end;

Procedure OddalitPohled;
begin
{ Editor.Pohled.KrokZvetseni:=Editor.Pohled.Zvetseni div 10;}
 If Editor.Pohled.Zvetseni > MinZvetseni + Editor.Pohled.KrokZvetseni then
 Editor.Pohled.Zvetseni:=Editor.Pohled.Zvetseni - Editor.Pohled.KrokZvetseni;
end;

Procedure PosunoutPohled(Smer : TSmer);
var Posun : Sour;
begin
  Posun:=Round((2) / (Editor.Pohled.Zvetseni / 100));
  If Posun < 1 then Posun:=1;
  Case Smer of
   Nahoru : If Editor.Pohled.Ypos > -maxint then Editor.Pohled.Ypos:=Editor.Pohled.Ypos-posun;
   Dolu   : If Editor.Pohled.Ypos < maxint then Editor.Pohled.Ypos:=Editor.Pohled.Ypos+posun;
   Vlevo  : If Editor.Pohled.Xpos > -maxint then Editor.Pohled.Xpos:=Editor.Pohled.Xpos-posun;
   Vpravo : If Editor.Pohled.Xpos < maxint then Editor.Pohled.Xpos:=Editor.Pohled.Xpos+posun;
  end;
 PrekreslitPohled;
end;

Procedure PovelMenu;
var K, Kf : Char;
begin
 PanelMenu(' (N)acist, (U)lozit, ulozit j(A)ko, (G)roup manager, (K)onec');
   Repeat
     If KeyPressed then K:=ReadKey else K:=#255;
      If K = #0 then Kf:=ReadKey else Kf:=#255;
   Until K IN [KlEnter,KlEsc,'U','u','A','a','N','n','K','k','G','g'];
     Case K of
      'U','u':UlozCuprex(AktualniCuprex);
      'A','a':UlozCuprexJako(AktualniCuprex);
      'N','n':begin
               HidePointer; SetFillStyle(0,0); Bar(MinX,MinY,MaxX,MaxY);
               VyberSoubor; PrekreslitPohled; ZobrazujPanel; ShowPointer;
              end;
      'G','g':If AktualniCuprex <> nil then
              begin
               HidePointer; SetFillStyle(0,0); Bar(MinX,MinY,MaxX,MaxY);
               GroupManager(AktualniCuprex); PrekreslitPohled; ZobrazujPanel; ShowPointer;
              end;
      'K','k':Editor.Akce:=ActKonec;
     end;
 ZobrazujPanel;
end;

Procedure ProvedAkci;
begin
 Case Editor.Akce of
        ActNic : Editor.PouzivanyBod := nil;
  ActPosunBodu : begin
                  If Editor.PouzivanyBod <> nil then
                   begin
                    Editor.PouzivanyBod^.X:=ToGrid(MouXsour);
                    Editor.PouzivanyBod^.Y:=ToGrid(MouYsour);
                    If Editor.MouseMoved then PrekreslitPohled;
                   end else Editor.Akce:=ActNic;
                  If NOT LBPressed then Editor.Akce:=ActNic;
                 end;
   ActNovySpoj : begin
                  If Editor.PouzivanyBod = nil then
                    begin
                     If AktualniBod <> nil then Editor.PouzivanyBod:=AktualniBod
                      else VytvorBod(Editor.PouzivanyBod,AktualniCuprex,AktualniSkupina,ToGrid(MouXsour),ToGrid(MouYsour),0);
                    end;
                  If Editor.MouseMoved then PrekreslitPohled;
                  SetColor(15);
                  LineScaled(Editor.PouzivanyBod^.X,Editor.PouzivanyBod^.Y,ToGrid(MouXsour),ToGrid(MouYsour));
                 end;
ActDokonciSpoj : If Editor.PouzivanyBod <> nil then
                   begin
                    If AktualniBod = nil then
                     VytvorBod(AktualniBod,AktualniCuprex,AktualniSkupina,ToGrid(MouXsour),ToGrid(MouYsour),0);
                    VytvorSpojB(AktualniSpoj,AktualniCuprex,Editor.PouzivanyBod,AktualniBod);
                    Editor.PouzivanyBod := nil;
                    Editor.Akce:=ActNic;
                   end else Editor.Akce:=ActNic;
 end;
end;


var K, Kf : Char;
    gD, gM: Integer;
    PBd:Word;

begin
 MaxAvMem := MemAvail;
 gD := Detect;
 InitGraph(gD, gM,'C:\PROGRAMY\BP\BGI');

 HlavniCuprex:=nil;
 AktualniCuprex:=nil;
 AktualniSkupina:=nil;
 AktualniBod:=nil;
 MinulyBod:=AktualniBod;
 AktualniSpoj:=nil;
 VytvorCuprex(AktualniCuprex);
 VytvorPodSkupinu(AktualniSkupina,AktualniCuprex,nil);
 VytvorObrys(AktualniCuprex^.HlavniObrys, AktualniCuprex, AktualniSkupina);
 NastavAktualniUkazatele(AktualniCuprex);

 Editor.Grid.Xpos:=0;
 Editor.Grid.Ypos:=0;
 Editor.Grid.On:=FALSE;
 Editor.Grid.Modul:=128;

 Editor.Pohled.Xpos:=0; {0}
 Editor.Pohled.Ypos:=0; {0}
 Editor.Pohled.Xmed:=CenterX;
 Editor.Pohled.Ymed:=CenterY;
 Editor.Pohled.KrokZvetseni:=10;
 Editor.Pohled.Zvetseni:=100;
 Editor.RBmax:=RBmax; {maximalni vzdalenost od bodu, aby byl oznacen}
 Editor.Rmax:=Rmax;  {maximalni vzdalenost od spoje, aby byl oznacen}
 Editor.PouzivanyBod := nil;
 Editor.PointMode := 0;
 ShowPointer;
{ Kursor, Pes, Kursor3, Kriz, Hodiny, Otaznik,
 Sipka, Listecek, Krizek, Fatcurs, Pogocurs}
{ MouseSetGrCurs(0,0, Pogocurs);}
 SetTextStyle(DefaultFont, HorizDir, 1);
 PrekreslitPohled;
 ZobrazujPanel;
 repeat
  GetMouseMove;
  If Editor.MouseMoved then PanelSouradnice;
  If (Editor.PointMode = 1) AND (AktualniBod <> MinulyBod) AND (Editor.MouseMoved) then PrekreslitPohled;
  If Editor.PointMode <> 0 then ZobrazujBody;
  ZobrazujSpoje(AktualniCuprex);
  MinulyBod:=AktualniBod;
  ProvedAkci;

  HledejSpojPohled(AktualniSpoj, AktualniCuprex, MouX, MouY);
  HledejBodPohled(AktualniBod, AktualniCuprex, MouX, MouY);

  If LBPressed then
   begin
    If Editor.Akce = ActNic then
     begin
      HledejVetev(AktualniCuprex,AktualniSpoj);
      Editor.PouzivanyBod:=AktualniBod;
      Editor.Akce:=ActPosunBodu;
     end;
(*    While LBPressed do
     begin
{      If AktualniBod <> nil then
       begin
        AktualniBod^.X:=ToGrid(MouXsour,Editor.Grid.Oko);
        AktualniBod^.Y:=ToGrid(MouYsour,Editor.Grid.Oko);
       end;}
      Bar(MinX,MinY,MaxX,MaxY);
{      ClearDevice;}
      ZobrazujBody;
      ZobrazujSpoje;
      ZobrazujGrid;
{      SetColor(11); Rectangle(Xp,Yp,MouX,MouY);}
     end;
{    HledejSpoje(Xp,Yp,MouX,MouY,Entity.PosledniSpoj);}
*)
   end;

  If RBPressed then
   begin
    Editor.Pohled.Xpos:=PohledNaSourX(MouX);
    Editor.Pohled.Ypos:=PohledNaSourY(MouY);
    GetPohledMove;
    If Editor.PohledMoved then PrekreslitPohled;
    MouseSetPos(Editor.Pohled.Xmed,Editor.Pohled.Ymed);
   end;

  If KeyPressed then K:=ReadKey else K:=#255;
   If K=#0 then Kf:=ReadKey else Kf:=#255;

  Case K of
   #32:begin
        If Editor.Akce = ActNovySpoj then Editor.Akce:=ActDokonciSpoj;
        If Editor.Akce = ActNic then Editor.Akce:=ActNovySpoj;
{         If Editor.PouzivanyBod = nil then
          begin
           If AktualniBod <> nil then Editor.PouzivanyBod:=AktualniBod
           else VytvorBod(Editor.PouzivanyBod,ToGrid(MouXsour),ToGrid(MouYsour));
          end else
          begin
           If AktualniBod = nil then VytvorBod(AktualniBod,ToGrid(MouXsour),ToGrid(MouYsour));
           VytvorSpojB(Editor.PouzivanyBod,AktualniBod);
           Editor.PouzivanyBod := nil;
          end;}
       end;
   KlEsc: PovelMenu;
   'L','l':begin Editor.Grid.On:=NOT Editor.Grid.On; PrekreslitPohled; end;
   'G','g':If Editor.Grid.Modul > 4 then begin Editor.Grid.Modul:=Editor.Grid.Modul div 2; PrekreslitPohled; end
                                  else begin Editor.Grid.Modul:=128; PrekreslitPohled; end;
   'R','r':begin ZrusPrazdneBody(AktualniCuprex); PrekreslitPohled; end;
   'P','p':begin Editor.PointMode:=(Editor.PointMode + 1) mod 3; PrekreslitPohled; end;
   'E','e':begin ZakonciBody(AktualniCuprex); PrekreslitPohled; end;
   '+','A','a':begin PriblizitPohled; PrekreslitPohled; PanelSouradnice; end;
   '-','Z','z':begin OddalitPohled; PrekreslitPohled; PanelSouradnice; end;
 {  'X','x':begin ZrusCuprex(AktualniCuprex); NastavAktualniUkazatele(HlavniCuprex); end;}
  end;
  Case Kf of
   KlfNahoru : PosunoutPohled(Nahoru);
   KlfDolu   : PosunoutPohled(Dolu);
   KlfVlevo  : PosunoutPohled(Vlevo);
   KlfVpravo : PosunoutPohled(Vpravo);
   KlfDel    : begin ZrusSpoj(AktualniSpoj, AktualniCuprex); ZrusPrazdneBody(AktualniCuprex); PrekreslitPohled; end;
   KlfIns    : begin RozdelSpoj(AktualniSpoj,AktualniCuprex,AktualniSkupina,MouX,MouY); PrekreslitPohled; end;
  end;
 until (Kf=KlfAltF4) OR (Editor.Akce=ActKonec);
 HidePointer;
 CloseGraph;
 nosound;
 If AktualniCuprex <> nil then PBd:=AktualniCuprex^.PocetBodu;
 MinAvMem:=MemAvail;
 ZrusVsechnyCuprexy;
 WriteLn; WriteLn('Celkem bylo zruseno ',PBd,' bodu.');
 WriteLn('Stav haldy: - pred spustenim:     ',maxavmem,' Bytu.');
 WriteLn('            - pred vyklizenim:    ',minavmem,' Bytu.');
 WriteLn('            - po vyklizeni:       ',MemAvail,' Bytu.');
 WriteLn('            - neuklizeno zustalo: ',maxavmem-MemAvail,' Bytu.');
end.