{ Lukas Cerovsky - semestralni prace}
{ Jednotka pro zobrazovani a editaci Cuprexu}

unit CuprexCanvasWriter;

interface

uses Graphics, dialogs, windows,
     CuprexTypes, CuprexDataClass;

type
    TGrid = Record
             Visible : Boolean;
             Active : Boolean;
             Modul : Sour;
             Xpos, Ypos : Sour;
            end;
     TPos = Record
             Visible : Boolean;
             Xpos, Ypos : Sour;
            end;
 TChanged = Record
             Bod: Boolean;
             Spoj: Boolean;
             Uzel: Boolean;
             Obrys: Boolean;
             Skupina: Boolean;
            end;
  SourPtr = ^Sour;
  TPohled = Record
             AktivniBod : BodPtr;
             AktivniSpoj : SpojPtr;
             AktivniUzel : UzelPtr;
             AktivniObrys : ObrysPtr;
             AktivniSkupina : SkupinaPtr;
             AktivniX : SourPtr;
             AktivniY : SourPtr;
             FPos : TPos;
             VirtFPos : TPos;
             MousePos : TPos;
             FGrid : TGrid;
             Changed : TChanged;
             Xmed, Ymed : Pix;
             MinX, MinY, MaxX, MaxY : Pix;
             FScale : Word;
             UnitsInPixel : Longint;
             PointMode : Byte;
             EditMode : Byte;
             AktivniXYLocked : Boolean;
             Moving : Boolean;
            end;

TCanvasWriter = class (TObject)
  private
    FCanvas : TCanvas;

    function PohledNaSour(P : Pix; const Pohled : TPohled) : Sour;
    function PohledNaSourX(P : Pix; const Pohled : TPohled) : Sour;
    function PohledNaSourY(P : Pix; const Pohled : TPohled) : Sour;
    function SourNaPohled(S : Sour; const Pohled : TPohled) : Pix;
    function SourNaPohledX(S : Sour; const Pohled : TPohled) : Pix;
    function SourNaPohledY(S : Sour; const Pohled : TPohled) : Pix;
    function RoundToGrid(X : Sour; const Pohled : TPohled) : Sour;
    function OpsanyStred(Xa, Ya, Xb, Yb, Xm, Ym : Sour; var Xs, Ys : Sour) : Boolean;
//    procedure VzdalenostOdCary(X1, Y1, X2, Y2, Xm, Ym : Sour; var R : Sour);
    procedure NajdiNejblizsiBod(var Pohled : TPohled; Xs, Ys : Sour);
    procedure NajdiNejblizsiSpoj(var Pohled : TPohled; Xs, Ys : Sour);
    procedure NajdiNejblizsiObrys(var Pohled : TPohled; Xs, Ys : Sour);
    procedure LineScaled(X1, Y1, X2, Y2 : Sour; const Pohled : TPohled);
    procedure ZobrazSpoje(const Pohled : TPohled);
    procedure ZobrazObrysy(const Pohled : TPohled);
    procedure ZobrazBody(const Pohled : TPohled);
    procedure ZobrazGrid(const Pohled : TPohled);
    procedure ZobrazPozici(const Pohled : TPohled);
    procedure ZobrazCtverecek(const X, Y, R : Pix; const Pohled : TPohled);

  protected

  public
    FMyCuprex : TCuprex;
    BoduNaKruznici : Word;
    constructor CreateOnCuprex(Cuprex : TCuprex);
    procedure SetCuprex (Cuprex : TCuprex);
    procedure SetPohledPosition (Xpos, Ypos : Pix; var Pohled : TPohled);
    procedure SetOutputArea (var Pohled: TPohled; Left, Top, Right, Bottom : Pix);
    procedure SetActiveXY (var Pohled : TPohled; Xm, Ym : Pix);
    procedure NewVirtualPos(var Pohled : TPohled; Xm, Ym : Pix);
    procedure SetPohledPosByVirtual(var Pohled : TPohled; Xm, Ym : Pix);
    procedure SetMouseXY (var Pohled : TPohled; Xm, Ym : Pix);
    procedure CuprexNaCanvas (Canvas : TCanvas; const Pohled : TPohled);
    procedure ZmenyNaCanvas (Canvas : TCanvas; var Pohled : TPohled);
    procedure NajdiNejblizsi(var Pohled : TPohled; Xm, Ym : Pix);
    procedure ZobrazPoziciXY(Xpoh, Ypoh : Pix; const Pohled : TPohled);
    procedure Kruznice(var Pohled : TPohled; Spoj : SpojPtr; Xm, Ym : Pix);
    procedure RozdelSpoj(var Pohled : TPohled);
    procedure VytvorSpoj (var Pohled : TPohled);

  published

  end;

const
   DefScale = 100;
   DefGrid : TGrid = (Visible : FALSE; Active : FALSE; Modul : 2500; Xpos : 0; Ypos : 0);
   DefPos : TPos = (Visible : TRUE; Xpos : 0; Ypos : 0);
   DefChanged : TChanged = (Bod: FALSE; Spoj: FALSE; Uzel: FALSE; Obrys: FALSE; Skupina: FALSE);
   DefPohled : TPohled = (AktivniBod: nil; AktivniSpoj: nil; AktivniUzel: nil; AktivniObrys: nil;
       AktivniSkupina: nil; AktivniX: nil; AktivniY: nil; PointMode: 0; EditMode: 0;
       AktivniXYLocked: FALSE; Moving: FALSE);
   pmNo = 0;
   pmOne = 1;
   pmAll = 2;
   emView = 0;
   emSpoje = 1;
   emObrysy = 2;
   maxScale = 1001;
   minScale = 10;
   maxGridModul = 100001;
   minGridModul = 10;
   defUnitsInPixel = 1000; {bude se nastavovat v Nastavenich, nacte se z cuprexu}
   rBmax = 10; {bude se nastavovat v Nastavenich, od Bodu nebo uzlu}
   rOmax = 10; {bude se nastavovat v Nastavenich, od cary Obrysu}
   rSmax = 10; {bude se nastavovat v Nastavenich, od Spoje}
   clGrid = $00BBBBBB; {bude se nastavovat v Nastavenich}
   clBod = clGreen; {bude se nastavovat v Nastavenich}
   clBodAktivni = clLime; {bude se nastavovat v Nastavenich}
   clSpoj = clBlack; {bude se nastavovat v Nastavenich}
   clSpojAktivni = clRed; {bude se nastavovat v Nastavenich}
   clSpojVybrany = $00FF88FF;
   clpObrys = clBlue; {bude se nastavovat v Nastavenich}
   clpObrysAktivni = clRed; {bude se nastavovat v Nastavenich}
   clpObrysVybrany = $00EE00EE;
   clbObrys = clWhite; {bude se nastavovat v Nastavenich}
   clbObrysAktivni = clRed; {bude se nastavovat v Nastavenich}
   clbObrysVybrany = $00FF88FF;
   clUzel = clGreen;
   clUzelAktivni = clLime;
//   clUzelVybrany = $00FF88FF;

implementation


Constructor TCanvasWriter.CreateOnCuprex(Cuprex : TCuprex);
begin
 Create;
 FMyCuprex := Cuprex;
end;

Function TCanvasWriter.PohledNaSour(P : Pix; const Pohled : TPohled) : Sour;
begin
 PohledNaSour := ((P * Pohled.UnitsInPixel * 100) div Pohled.FScale);
end;

Function TCanvasWriter.PohledNaSourX(P : Pix; const Pohled : TPohled) : Sour;
begin
 PohledNaSourX := (((P-Pohled.Xmed) * Pohled.UnitsInPixel * 100) div Pohled.FScale) + Pohled.FPos.Xpos;
end;

Function TCanvasWriter.PohledNaSourY(P : Pix; const Pohled : TPohled) : Sour;
begin
 PohledNaSourY := (((P-Pohled.Ymed) * Pohled.UnitsInPixel * 100) div Pohled.FScale) + Pohled.FPos.Ypos;
end;

Function TCanvasWriter.SourNaPohled(S : Sour; const Pohled : TPohled) : Pix;
var T : Sour;
begin
 T := ((S * Pohled.FScale) / (100 * Pohled.UnitsInPixel));
 SourNaPohled := Round(T);
end;

Function TCanvasWriter.SourNaPohledX(S : Sour; const Pohled : TPohled) : Pix;
var T : Sour;
begin
 T := (((S-Round(Pohled.FPos.Xpos)) * Pohled.FScale) / (100 * Pohled.UnitsInPixel));
 SourNaPohledX := Round(T) + Pohled.Xmed;
end;

Function TCanvasWriter.SourNaPohledY(S : Sour; const Pohled : TPohled) : Pix;
var T : Sour;
begin
 T := (((S-Round(Pohled.FPos.Ypos)) * Pohled.FScale) / (100 * Pohled.UnitsInPixel));
 SourNaPohledY := Round(T) + Pohled.Ymed;
end;

Function TCanvasWriter.RoundToGrid(X : Sour; const Pohled : TPohled) : Sour;
begin
 If Pohled.FGrid.Active then
  RoundToGrid:=Round(X / Pohled.FGrid.Modul) * Pohled.FGrid.Modul else RoundToGrid:=X;
end;

Function TCanvasWriter.OpsanyStred(Xa, Ya, Xb, Yb, Xm, Ym : Sour; var Xs, Ys : Sour) : Boolean;
var dXma, dYma, dXmb, dYmb : Sour; {urci stred thaletovy kruznice pro body A, B, M}
    det, t : real;
begin
 dXma := Xm - Xa; dYma := Ym - Ya;
 dXmb := Xm - Xb; dYmb := Ym - Yb;
 det := (dYmb * dXma) - (dYma * dXmb);
 If det <> 0 then
  begin
   t := ((dYmb * (Ya - Yb)) + (dXmb * (Xa - Xb))) / (det * 2);
   Xs := ((Xa + Xm) / 2) + (t * dYma);
   Ys := ((Ya + Ym) / 2) - (t * dXma);
   OpsanyStred := TRUE;
  end else OpsanyStred := FALSE;
end;

{
Procedure VzdalenostOdCary(X1, Y1, X2, Y2, Xm, Ym : Sour; var R : Sour);
 var Xt, Yt, ux, uy : Sour;
     t : Real;
 begin
   ux:=X2-X1;
   uy:=Y2-Y1;
   If ux+uy <> 0 then
    begin
     t:=(-1)*(ux*(X1-Xm)+uy*(Y1-Ym))/(ux*ux+uy*uy);
     If T > 1 then T:=1;
     If T < 0 then T:=0;
     Xt:=X1 + (ux*t);
     Yt:=Y1 + (uy*t);
     R:=(sqrt(sqr(Xt-Xm)+sqr(Yt-Ym)));
    end;
 end;
}

Procedure TCanvasWriter.NajdiNejblizsiBod(var Pohled : TPohled; Xs, Ys : Sour);
 var TempBod, Last : BodPtr;
     Rb, Rbmin : Sour;
 begin
   TempBod := FMyCuprex.GetHlavniBod;
   Last := Pohled.AktivniBod;
   Rbmin := PohledNaSour(Rbmax, Pohled);
//   Pohled.AktivniBod:=nil;
    While TempBod <> nil do
     begin
      Rb:=Round(Sqrt(Sqr(TempBod^.X-Xs)+Sqr(TempBod^.Y-Ys)));
      If Rb < Rbmin then begin Rbmin:= Rb; Pohled.AktivniBod := TempBod; end;
      TempBod := TempBod^.Dalsi;
     end;
   Pohled.Changed.Bod := (Last <> Pohled.AktivniBod);
 end;

Procedure TCanvasWriter.NajdiNejblizsiSpoj(var Pohled : TPohled; Xs, Ys : Sour);
 var TempSpoj, Last : SpojPtr;
     X0, Y0, Xt, Yt, ux, uy : Sour;
     R, Rmin : Sour;
     t : Real;
 begin
    TempSpoj := FMyCuprex.GetHlavniSpoj;
    Last := Pohled.AktivniSpoj;
    Rmin := PohledNaSour(rSmax,Pohled);
//    Pohled.AktivniSpoj:=nil;
    While TempSpoj <> nil do
     begin
      X0:=TempSpoj^.Zacatek^.X;
      Y0:=TempSpoj^.Zacatek^.Y;
      ux:=TempSpoj^.Konec^.X-TempSpoj^.Zacatek^.X;
      uy:=TempSpoj^.Konec^.Y-TempSpoj^.Zacatek^.Y;
      If ux+uy <> 0 then
       begin
        t:=(-1)*(ux*(X0-Xs)+uy*(Y0-Ys))/(ux*ux+uy*uy);
        If T>1 then T:=1;
        If T<0 then T:=0;
        Xt:=X0+Round(ux*t);
        Yt:=Y0+Round(uy*t);
        R:=Round(sqrt(sqr(Xt-Xs)+sqr(Yt-Ys)));
        If R < Rmin then begin Pohled.AktivniSpoj:=TempSpoj; Rmin:=R; end;
       end;
      TempSpoj := TempSpoj^.Dalsi;
     end;
    Pohled.Changed.Spoj := (Last <> Pohled.AktivniSpoj);
 end;

Procedure TCanvasWriter.NajdiNejblizsiObrys(var Pohled : TPohled; Xs, Ys : Sour);
 var TempObrys, LastObrys : ObrysPtr;
     TempUzel, LastUzel : UzelPtr;
     X0, Y0, Xt, Yt, ux, uy : Sour;
     R, Rb, Rmin, Rbmin : Sour;
     t : Real;
 begin
   TempObrys := FMyCuprex.GetHlavniObrys;
   Rmin := PohledNaSour(rOmax, Pohled);
   Rbmin := PohledNaSour(rBmax, Pohled);
   LastObrys := Pohled.AktivniObrys;
   LastUzel := Pohled.AktivniUzel;
//   Pohled.AktivniObrys := nil;
//   Pohled.AktivniUzel := nil;
   While TempObrys <> nil do
    begin
     TempUzel := TempObrys^.HlavniUzel;
      While TempUzel <> nil do
       begin
        Rb:=Round(Sqrt(Sqr(TempUzel^.X-Xs)+Sqr(TempUzel^.Y-Ys)));
        If Rb < Rbmin then begin Rbmin:= Rb; Pohled.AktivniUzel:=TempUzel; end;
        X0:=TempUzel^.X;
        Y0:=TempUzel^.Y;
        TempUzel := TempUzel^.Dalsi;
        If TempUzel <> nil then
         begin
          ux:=TempUzel^.X - X0;
          uy:=TempUzel^.Y - Y0;
         end else
         begin
          ux:=TempObrys^.HlavniUzel^.X - X0;
          uy:=TempObrys^.HlavniUzel^.Y - Y0;
         end;
        If ux+uy <> 0 then
         begin
          t:=(-1)*(ux*(X0-Xs)+uy*(Y0-Ys))/(ux*ux+uy*uy);
          If T>1 then T:=1;
          If T<0 then T:=0;
          Xt:=X0+Round(ux*t);
          Yt:=Y0+Round(uy*t);
          R:=Round(sqrt(sqr(Xt-Xs)+sqr(Yt-Ys)));
          If R < Rmin then begin Pohled.AktivniObrys:=TempObrys; Rmin:=R; end;
         end;
       end;
     TempObrys := TempObrys^.Dalsi;
    end;
   Pohled.Changed.Obrys := (LastObrys <> Pohled.AktivniObrys);
   Pohled.Changed.Uzel := (LastUzel <> Pohled.AktivniUzel);
 end;

Procedure TCanvasWriter.NajdiNejblizsi(var Pohled : TPohled; Xm, Ym : Pix);
 var Xs, Ys : Sour;
begin
  Xs:=PohledNaSourX(Xm, Pohled);
  Ys:=PohledNaSourY(Ym, Pohled);
  Pohled.AktivniBod := nil;
  Pohled.AktivniSpoj := nil;
  Pohled.AktivniUzel := nil;
  Pohled.AktivniObrys := nil;
  Pohled.AktivniSkupina := nil;
  If Pohled.EditMode = emSpoje then NajdiNejblizsiBod(Pohled, Xs, Ys);
  If Pohled.EditMode = emSpoje then NajdiNejblizsiSpoj(Pohled, Xs, Ys);
  If Pohled.EditMode = emObrysy then NajdiNejblizsiObrys(Pohled, Xs, Ys);
  If Pohled.AktivniObrys<>nil then Pohled.AktivniSkupina:=Pohled.AktivniObrys^.Master;
  If Pohled.AktivniBod<>nil then Pohled.AktivniSkupina:=Pohled.AktivniBod^.Master;
end;

Procedure TCanvasWriter.Kruznice(var Pohled : TPohled; Spoj : SpojPtr; Xm, Ym : Pix);
 var X, Y, Xs, Ys, R : Sour;
     X1, X2, Y1, Y2 : Sour;
     angle1, angle2, angleStep : Extended;
begin
 If Spoj <> nil then
  If (Spoj^.Zacatek <> nil) AND (Spoj^.Konec <> nil) then
  begin
   X:=PohledNaSourX(Xm, Pohled);
   Y:=PohledNaSourY(Ym, Pohled);
   If OpsanyStred(Spoj^.Zacatek^.X,Spoj^.Zacatek^.Y,Spoj^.Konec^.X,Spoj^.Konec^.Y,X,Y,Xs,Ys) then
    begin     //thaletuv stred vraci divne hodnoty
     R := Sqrt(Sqr(Xs-X)+Sqr(Ys-Y)); {radius}
{     R:=50000;
     Xs := 0;
     Ys := 0;}
     Linescaled(Xs-10000,Ys,Xs+10000,Ys, pohled);
     Linescaled(Xs,Ys-10000,Xs,Ys+10000, pohled);
               // vyresit prevod na polarni souradnice
     angleStep := Pi / 8;
     angle1 := 0;
     While Angle1 < (2*Pi) do
      begin
       angle2 := angle1 + angleStep;
       X1 := Round(Xs+(R*cos(angle1)));
       Y1 := Round(Ys+(R*sin(angle1)));
       X2 := Round(Xs+(R*cos(angle2)));
       Y2 := Round(Ys+(R*sin(angle2)));
       LineScaled(X1,Y1,X2,Y2,Pohled);
       angle1 := angle2;
      end;
    end;
  end;
end;



Procedure TCanvasWriter.LineScaled(X1, Y1, X2, Y2 : Sour; const Pohled : TPohled);
 procedure HledejPrusecik(Xh0, Yh0, Xh, Yh : Sour; var Px, Py : Sour);
 var t : Real;
     uhx, uhy, ux, uy : Sour;
 begin
  uhx:=Xh-Xh0; uhy:=Yh-Yh0;
  ux:=X2-X1;   uy:=Y2-Y1;
  If (uhy * ux  -  uhx * uy) <> 0 then
    t:=(uhx * (Y1-Yh0)  -  uhy * (X1-Xh0)) / (uhy * ux  -  uhx * uy) else t:=2;
  If (t >= 0) AND (t <= 1) then //Prusecik je na care
   begin
    Px:=Round(X1+t*ux);
    Py:=Round(Y1+t*uy);
   end;
 end;
var minX, minY, maxX, maxY : Pix;
begin
 X1:=SourNaPohledX(X1,Pohled);
 X2:=SourNaPohledX(X2,Pohled);
 Y1:=SourNaPohledY(Y1,Pohled);
 Y2:=SourNaPohledY(Y2,Pohled);
 minX := Pohled.MinX;
 minY := Pohled.MinY;
 maxX := Pohled.MaxX;
 maxY := Pohled.MaxY;
//prusecik s hornim okrajem
 If Y1 < MinY then HledejPrusecik(MinX,MinY,MaxX,MinY,X1,Y1);
 If Y2 < MinY then HledejPrusecik(MinX,MinY,MaxX,MinY,X2,Y2);
//prusecik s dolnim okrajem
 If Y1 > MaxY then HledejPrusecik(MinX,MaxY,MaxX,MaxY,X1,Y1);
 If Y2 > MaxY then HledejPrusecik(MinX,MaxY,MaxX,MaxY,X2,Y2);
//prusecik s levym okrajem
 If X1 < MinX then HledejPrusecik(MinX,MinY,MinX,MaxY,X1,Y1);
 If X2 < MinX then HledejPrusecik(MinX,MinY,MinX,MaxY,X2,Y2);
//prusecik s pravym okrajem
 If X1 > MaxX then HledejPrusecik(MaxX,MinY,MaxX,MaxY,X1,Y1);
 If X2 > MaxX then HledejPrusecik(MaxX,MinY,MaxX,MaxY,X2,Y2);
//nakresleni cary po omezeni souradnic
 If (X1 >= MinX) AND (X1 <= MaxX) AND (Y1 >= MinY) AND (Y1 <= MaxY) AND
    (X2 >= MinX) AND (X2 <= MaxX) AND (Y2 >= MinY) AND (Y2 <= MaxY) then
    begin
     FCanvas.MoveTo (Round(X1),Round(Y1));
     FCanvas.LineTo (Round(X2),Round(Y2));
    end;
end;

Procedure TCanvasWriter.ZobrazCtverecek(const X, Y, R : Pix; const Pohled : TPohled);
var BodRect : TRect;
begin
  BodRect.Left   := X - R;
  BodRect.Top    := Y - R;
  BodRect.Right  := X + R;
  BodRect.Bottom := Y + R;
  If (BodRect.Left >= Pohled.MinX) AND (BodRect.Left <= Pohled.MaxX) AND
     (BodRect.Top >= Pohled.MinY) AND (BodRect.Top <= Pohled.MaxY) AND
     (BodRect.Right >= Pohled.MinX) AND (BodRect.Right <= Pohled.MaxX) AND
     (BodRect.Bottom >= Pohled.MinY) AND (BodRect.Bottom <= Pohled.MaxY) then
    FCanvas.FrameRect(BodRect);
end;

Procedure TCanvasWriter.ZobrazGrid (const Pohled : TPohled);
var Xp, XM : Sour;
    Xpohl : Pix;
begin
 If (Pohled.FGrid.Visible) AND (Pohled.FGrid.Modul <> 0) then
  begin
   FCanvas.Pen.Color:=clGrid;
   FCanvas.Pen.Width:=1;
   Xp:=Round(PohledNaSourX(Pohled.MinX, Pohled) / Pohled.FGrid.Modul) * Pohled.FGrid.Modul;
   XM:=PohledNaSourX(Pohled.MaxX, Pohled);
   While Xp < XM do
    begin
     Xpohl := SourNaPohledX(Xp, Pohled);
     If (Xpohl > Pohled.MinX)AND(Xpohl < Pohled.MaxX) then
      begin
       FCanvas.MoveTo (Xpohl, Pohled.MinY);
       FCanvas.LineTo (Xpohl, Pohled.MaxY);
      end;
     Xp := Xp + Pohled.FGrid.Modul;
    end;
   Xp:=Round(PohledNaSourY(Pohled.MinY, Pohled) / Pohled.FGrid.Modul) * Pohled.FGrid.Modul;
   XM:=PohledNaSourY(Pohled.MaxY, Pohled);
   While Xp < XM do
    begin
     Xpohl := SourNaPohledY(Xp, Pohled);
     If (Xpohl > Pohled.MinY)AND(Xpohl < Pohled.MaxY) then
      begin
       FCanvas.MoveTo (Pohled.MinX, Xpohl);
       FCanvas.LineTo (Pohled.MaxX, Xpohl);
      end;
     Xp := Xp + Pohled.FGrid.Modul;
    end;
  end;
end;

Procedure TCanvasWriter.ZobrazObrysy (const Pohled : TPohled);
 Procedure ZobrazUzel (Uzel : UzelPtr);
  var X, Y : Pix;
  begin
   X := SourNaPohledX(Uzel^.X, Pohled);
   Y := SourNaPohledY(Uzel^.Y, Pohled);
   If Uzel = Pohled.AktivniUzel then FCanvas.Brush.Color:=clUzelAktivni
                                  else FCanvas.Brush.Color:=clUzel;
   Case Pohled.PointMode of
    pmOne : If Uzel = Pohled.AktivniUzel then ZobrazCtverecek(X, Y, 5, Pohled);
    pmAll : ZobrazCtverecek(X, Y, 5, Pohled);
   end;
  end;
 Procedure ZobrazujObrys(Obrys : ObrysPtr);
 var Uzel : UzelPtr;
 begin
  FCanvas.Pen.Width := 1;
  If Obrys <> nil then
   If Obrys^.HlavniUzel <> nil then
    begin
     Uzel:=Obrys^.HlavniUzel;
     While (Uzel <> nil) AND (Uzel^.Dalsi <> nil) do
      begin
       LineScaled(Uzel^.X,Uzel^.Y,Uzel^.Dalsi^.X,Uzel^.Dalsi^.Y, Pohled);
       If Pohled.EditMode = emObrysy then ZobrazUzel(Uzel);
       Uzel:=Uzel^.Dalsi;
      end;
     LineScaled(Uzel^.X,Uzel^.Y,Obrys^.HlavniUzel^.X,Obrys^.HlavniUzel^.Y, Pohled);
     If Pohled.EditMode = emObrysy then ZobrazUzel(Uzel);
    end;
 end;
var Obrys : ObrysPtr;
begin
 If FMyCuprex <> nil then
  begin
   FCanvas.Pen.Style:=psDot;
//   FCanvas.Brush.Color:=clWhite;
//   FCanvas.Pen.Color:=clBlue;
   Obrys:=FMyCuprex.GetHlavniObrys;
   While Obrys <> nil do
    begin
     If Obrys = Pohled.AktivniObrys then
      begin
       FCanvas.Pen.Color:=clpObrysAktivni;
       FCanvas.Brush.Color:=clbObrysAktivni;
      end else
      begin
       FCanvas.Pen.Color:=clpObrys;
       FCanvas.Brush.Color:=clbObrys;
       If Obrys^.Master.Attr AND caSelected = caSelected then
        begin
         FCanvas.Pen.Color:=clpObrysVybrany;
         FCanvas.Brush.Color:=clbObrysVybrany;
        end;
      end;
     ZobrazujObrys(Obrys);
     Obrys:=Obrys^.Dalsi;
    end;
   FCanvas.Pen.Style:=psSolid;
  end;
end;

Procedure TCanvasWriter.ZobrazSpoje (const Pohled : TPohled);
var TempSpoj : SpojPtr;
begin
 If FMyCuprex <> nil then
  begin
   FCanvas.Pen.Color:=clBlack;
   TempSpoj:=FMyCuprex.GetHlavniSpoj;
   While TempSpoj <> nil do
    begin
     If TempSpoj = Pohled.AktivniSpoj then FCanvas.Pen.Color:=clSpojAktivni
                                       else FCanvas.Pen.Color:=clSpoj;
     If TempSpoj^.Attr AND caSelected = caSelected then FCanvas.Pen.Color:=clSpojVybrany;
     FCanvas.Pen.Width := SourNaPohled(TempSpoj^.Width, Pohled);
     LineScaled(TempSpoj^.Zacatek^.X,TempSpoj^.Zacatek^.Y,
                TempSpoj^.Konec^.X,TempSpoj^.Konec^.Y, Pohled);
     TempSpoj := TempSpoj^.Dalsi;
    end;
  end;
end;

Procedure TCanvasWriter.ZobrazBody (const Pohled : TPohled);
 Procedure ZobrazDiru(X, Y, R : Pix);
 var X1, Y1, X2, Y2 : Pix;
 begin
  X1 := X - R;
  X2 := X + R;
  Y1 := Y - R;
  Y2 := Y + R;
  If (X1 > Pohled.minX) AND (X1 < Pohled.maxX) AND (X2 > Pohled.minX) AND (X2 < Pohled.maxX) AND
     (Y1 > Pohled.minY) AND (Y1 < Pohled.maxY) AND (Y2 > Pohled.minY) AND (Y2 < Pohled.maxY) then
   FCanvas.Ellipse(X1, Y1, X2, Y2);
 end;
 Procedure ZobrazBod(X, Y : Pix; Bod : BodPtr);
 begin
  If Bod = Pohled.AktivniBod then FCanvas.Brush.Color:=clBodAktivni
                             else FCanvas.Brush.Color:=clBod;
  Case Pohled.PointMode of
   pmOne : If Bod = Pohled.AktivniBod then ZobrazCtverecek(X, Y, 5, Pohled);
   pmAll : ZobrazCtverecek(X, Y, 5, Pohled);
  end;
 end;
var TempBod : BodPtr;
    X, Y : Pix;
begin
 If FMyCuprex <> nil then
  begin
   FCanvas.Pen.Width:=1;
   TempBod:=FMyCuprex.GetHlavniBod;
   While TempBod <> nil do
    begin
     X := SourNaPohledX(TempBod^.X, Pohled);
     Y := SourNaPohledY(TempBod^.Y, Pohled);
     If TempBod = Pohled.AktivniBod then
       begin
        FCanvas.Brush.Color:=clSpojAktivni;
        FCanvas.Pen.Color:=clSpojAktivni;
       end
       else
       begin
        FCanvas.Brush.Color:=clSpoj;
        FCanvas.Pen.Color:=clSpoj;
       end;
     If TempBod^.Attr AND caSelected = caSelected then
       begin
        FCanvas.Brush.Color:=clSpojVybrany;
        FCanvas.Pen.Color:=clSpojVybrany;
       end;
     ZobrazDiru(X,Y, SourNaPohled(TempBod^.HoleOut, Pohled));
{     FCanvas.Brush.Color:=clWhite;
     FCanvas.Pen.Color:=clWhite;
     ZobrazDiru(X,Y, SourNaPohled(TempBod^.HoleIn, Pohled));}
     If Pohled.EditMode = emSpoje then ZobrazBod(X, Y, TempBod);
     TempBod := TempBod^.Dalsi;
    end;
  end;
end;

Procedure TCanvasWriter.ZobrazPoziciXY(Xpoh, Ypoh : Pix; const Pohled : TPohled);
begin
 If ((Xpoh - 20) > Pohled.minX) AND ((Ypoh - 20) > Pohled.minY) AND
    ((Xpoh + 20) < Pohled.maxX) AND ((Ypoh + 20) < Pohled.maxY) then
  begin
   FCanvas.Pen.Width := 4;
   FCanvas.Pen.Color:=clBlack;
   FCanvas.MoveTo(Xpoh - 20, Ypoh);
   FCanvas.LineTo(Xpoh - 5, Ypoh);
   FCanvas.MoveTo(Xpoh + 5, Ypoh);
   FCanvas.LineTo(Xpoh + 20, Ypoh);
   FCanvas.MoveTo(Xpoh, Ypoh - 20);
   FCanvas.LineTo(Xpoh, Ypoh - 5);
   FCanvas.MoveTo(Xpoh, Ypoh + 5);
   FCanvas.LineTo(Xpoh, Ypoh + 20);
   FCanvas.Pen.Width := 1;
  end;
end;

Procedure TCanvasWriter.ZobrazPozici;
begin
 If Pohled.FPos.Visible then
  ZobrazPoziciXY(SourNaPohledX(Pohled.FPos.Xpos, Pohled),SourNaPohledY(Pohled.FPos.Ypos, Pohled),Pohled);
end;



Procedure TCanvasWriter.SetCuprex (Cuprex : TCuprex);
begin
 If Cuprex <> FMyCuprex then FMyCuprex := Cuprex;
end;

Procedure TCanvasWriter.SetPohledPosition (Xpos, Ypos : Pix; var Pohled : TPohled);
begin
 Pohled.FPos.Xpos := PohledNaSourX(Xpos, Pohled);
 Pohled.FPos.Ypos := PohledNaSourY(Ypos, Pohled);
end;

Procedure TCanvasWriter.SetActiveXY (var Pohled : TPohled; Xm, Ym : Pix);
begin
 If Pohled.AktivniX<>nil then Pohled.AktivniX^:=RoundToGrid(PohledNaSourX(Xm, Pohled), Pohled);
 If Pohled.AktivniY<>nil then Pohled.AktivniY^:=RoundToGrid(PohledNaSourY(Ym, Pohled), Pohled);
end;

Procedure TCanvasWriter.SetMouseXY (var Pohled : TPohled; Xm, Ym : Pix);
begin
 Pohled.MousePos.Xpos := PohledNaSourX(Xm, Pohled);
 Pohled.MousePos.Ypos := PohledNaSourY(Ym, Pohled);
end;

Procedure TCanvasWriter.NewVirtualPos(var Pohled : TPohled; Xm, Ym : Pix);
begin
 Pohled.VirtFPos.Xpos := PohledNaSourX(Xm, Pohled);
 Pohled.VirtFPos.Ypos := PohledNaSourY(Ym, Pohled);
end;

Procedure TCanvasWriter.SetPohledPosByVirtual(var Pohled : TPohled; Xm, Ym : Pix);
begin
 Pohled.FPos.Xpos := Pohled.FPos.Xpos - PohledNaSourX(Xm, Pohled) + Pohled.VirtFPos.Xpos;
 Pohled.FPos.Ypos := Pohled.FPos.Ypos - PohledNaSourY(Ym, Pohled) + Pohled.VirtFPos.Ypos;
end;



Procedure TCanvasWriter.SetOutputArea (var Pohled: TPohled; Left, Top, Right, Bottom : Pix);
begin
 If (Right > Left) AND (Bottom > Top) then
  begin
   Pohled.MinX := Left;
   Pohled.MinY := Top;
   Pohled.MaxX := Right;
   Pohled.MaxY := Bottom;
   Pohled.Xmed := (Right - Left) div 2 + Left;
   Pohled.Ymed := (Bottom - Top) div 2 + Top;
  end;
end;

Procedure TCanvasWriter.CuprexNaCanvas (Canvas : TCanvas; const Pohled : TPohled);
begin
 if FMyCuprex <> nil then
  begin
   FCanvas := Canvas; 
   FCanvas.Lock;
   ZobrazGrid(Pohled);
   ZobrazObrysy(Pohled);
   ZobrazSpoje(Pohled);
   ZobrazBody(Pohled);
   ZobrazPozici(Pohled);
   FCanvas.Unlock;
  end;
end;

Procedure TCanvasWriter.ZmenyNaCanvas (Canvas : TCanvas; var Pohled : TPohled);
begin
 if FMyCuprex <> nil then
  begin
   FCanvas := Canvas;
   FCanvas.Lock;
   If (Pohled.Changed.Obrys)OR(Pohled.Changed.Uzel) then ZobrazObrysy(Pohled);
   If Pohled.Changed.Spoj then ZobrazSpoje(Pohled);
   If (Pohled.Changed.Bod)OR(Pohled.Changed.Spoj) then ZobrazBody(Pohled);
   Pohled.Changed := DefChanged;
   ZobrazPozici(Pohled);
   Fcanvas.Unlock;
  end;
end;

Procedure TCanvasWriter.RozdelSpoj (var Pohled : TPohled);
var Xs, Ys : Sour;
begin
 Xs := Pohled.MousePos.Xpos;
 Ys := Pohled.MousePos.Ypos;
 FMyCuprex.RozdelSpoj(Pohled.AktivniSpoj, Pohled.AktivniSkupina, Xs, Ys);
end;

Procedure TCanvasWriter.VytvorSpoj (var Pohled : TPohled);
var Xs, Ys : Sour;
    Bod1, Bod2 : BodPtr;
    Spoj : SpojPtr;
begin
 Xs := Pohled.MousePos.Xpos;
 Ys := Pohled.MousePos.Ypos;
 Bod1 := Pohled.AktivniBod; Bod2 := nil;
 If Bod1 = nil then FMyCuprex.VytvorBod(Bod1,Pohled.AktivniSkupina,Xs,Ys,0);
 FMyCuprex.VytvorBod(Bod2,Pohled.AktivniSkupina,Xs,Ys,0);
 If Bod2 <> nil then
  begin
   FMyCuprex.VytvorSpojB(Spoj, Bod1, Bod2);
   Pohled.AktivniX := @Bod2^.X;
   Pohled.AktivniY := @Bod2^.Y;
  end;
end;

end.
