{ Lukas Cerovsky - semestralni prace}
{ Trida pro uschovu a praci s daty cuprexu}

unit CuprexDataClass; {jeste to chce predefinovat Create a Destroy}

interface

uses CuprexTypes;

const
       elCuprex = 'CUPREX';
       elNazev = 'NAZEV';
       elSkupina = 'SKUPINA';
       elObrys = 'OBRYS';
       elSpoje = 'SPOJE';
       elBody = 'BODY';
       elVerze = 'VERZE';
       elUnit = 'BASE_UNIT';
       elAttr = 'ATTR';
       elClose = '/';

type
  TCuprex = class (TObject)
   private
    FNazev : TNazev;             {Nazev cuprexu}
    FSoubor : String;            {Jmeno souboru}
    FModified : Boolean;          {neulozene zmeny}
    FPocetBodu, FPocetSpoju, FPocetObrysu, FPocetCar, FPocetSkupin : Integer;
    HlavniSkupina : SkupinaPtr;  {Seznam skupin}
    HlavniSpoj : SpojPtr;        {Seznam spoju}
    HlavniBod : BodPtr;          {Seznam bodu}
    HlavniObrys : ObrysPtr;      {Seznam obrysu}
   {CUPREX tvorici...}
    procedure VytvorCaru(var Uzel : UzelPtr; var Obrys : ObrysPtr; X, Y : Sour);
    procedure VytvorObrys(var Obrys : ObrysPtr; NadSkupina : SkupinaPtr);
    procedure VytvorPodSkupinu(var Skupina : SkupinaPtr; NadSkupina : SkupinaPtr);
   {CUPREX borici...}
    procedure ZrusVsechnyBody(var Bod : BodPtr);
    procedure ZrusVsechnySpoje(var Spoj : SpojPtr);
    procedure ZrusVsechnyCary(var Uzel : UzelPtr);
    procedure ZrusVsechnyObrysy(var Obrys : ObrysPtr);
    procedure ZrusVsechnySkupiny(var Skupina : SkupinaPtr);

    procedure HledejBodIndex(var Bod : BodPtr; Index : Word);
    procedure NactiSoubor(Soubor : String);

   public
    FVerze : Byte;
    FUnitsInPixel : Longint;
    constructor CreateFromFile(Soubor : String);
    destructor Destroy; override;
    procedure SaveToFile (Soubor : string);
    function GetHlavniSpoj : SpojPtr;
    function GetHlavniBod : BodPtr;
    function GetHlavniObrys : ObrysPtr;
    function GetHlavniSkupina : SkupinaPtr;
    function GetSoubor : String;
    function GetNazev : String;
    function GetPocetBodu : Integer;
    function GetPocetSpoju : Integer;
    function GetPocetObrysu : Integer;
    function GetPocetCar : Integer;
    function GetPocetSkupin : Integer;
    function Modified : Boolean;

    procedure ZrusBod(var Bod : BodPtr);
    procedure ZrusSpoj(var Spoj : SpojPtr);
    procedure ZrusObrys(var Obrys : ObrysPtr);
    procedure ZrusSkupinu(var Skupina : SkupinaPtr);
    procedure RozpustSkupinu(var Skupina : SkupinaPtr);
    procedure SjednotVybraneSkupiny;
    procedure VytvorSousedniSkupinu(Sousedni : SkupinaPtr; Nazev : TNazev);
    procedure RozdelSpoj(var Spoj : SpojPtr; Skupina : SkupinaPtr; Xp, Yp : Sour);
    procedure VytvorBod(var Bod : BodPtr; Skupina : SkupinaPtr; X, Y : Sour; Index : Word);
    procedure VytvorSpojB (var Spoj : SpojPtr; Bod1, Bod2 : BodPtr);

    procedure OznacBod(const Bod : BodPtr);
    procedure OznacJedenBod(const Bod : BodPtr);
    procedure OznacSpoj(const Spoj : SpojPtr);
    procedure OznacJedenSpoj(const Spoj : SpojPtr);
    procedure OznacVetev(const Spoj : SpojPtr);
    procedure OznacObrys(const Obrys : ObrysPtr);
    procedure OznacJedenObrys(const Obrys : ObrysPtr);

    procedure SetWidthToSelected(Width : Sour);
    procedure SetHoleInToSelected(HoleIn : Sour);
    procedure SetHoleOutToSelected(HoleOut : Sour);

   published

  end;

implementation

uses Dialogs, Controls, SysUtils;

Constructor TCuprex.CreateFromFile (Soubor : String);
begin
  Create;
  FPocetBodu := 0;
  FPocetSpoju := 0;
  FPocetObrysu := 0;
  FPocetCar := 0;
  FPocetSkupin := 0;
  FUnitsInPixel := 1000;
  HlavniSpoj := nil;
  HlavniBod := nil;
  HlavniSkupina := nil;
  HlavniObrys := nil;
  NactiSoubor(Soubor);
end;

Procedure TCuprex.NactiSoubor(Soubor : string);
const KodEOF = 1; KodObsah = 2; KodElement = 3; KodZavritElement = 4;
      PovoleneZnaky = ['0'..'9','A'..'Z','a'..'z',' '..'/',':','=','?'];
      Oddelovace = [';','='];

var T : Text;
    PosledniSkupina, PosledniNadSkupina : SkupinaPtr;
    PosledniObrys : ObrysPtr;
    PosledniBod : BodPtr;
    PosledniSpoj : SpojPtr;
    PosledniUzel : UzelPtr;
    PosledniNazev : ^TNazev;
    PosledniAtribut : ^TAttr;

 {Procedury k uprave ziskanych dat}
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0; If (I+Cnt <= Length(Zaznam)) then
   While (I+Cnt <= Length(Zaznam)) AND (Zaznam[I+Cnt] IN KtereZnaky) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;

 Procedure ZpracujBod(Zaznam : string);
 var I, Cnt: Byte;
     Index: Word;
     X, Y, HoleIn, HoleOut: Sour;
     Attr: Byte;
     ValCode: Integer;
 begin {Zaznam: 4(560.0,7800.0,500.0,1500.0,128)}
  I:=1; Cnt:=0;
  Filtruj([#0..#255] - ['0'..'9','.'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Index, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), X, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), Y, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.'],Zaznam,I,Cnt), HoleIn, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.'],Zaznam,I,Cnt), HoleOut, ValCode);
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Attr, ValCode);
  If FVerze = 1 then
   begin
    X:=X*1000; //prepocet kvuli novym souradnicim
    Y:=Y*1000;
   end;
  VytvorBod(PosledniBod,PosledniSkupina, X, Y, Index);
  If PosledniBod <> nil then PosledniBod^.Attr := Attr;
  If PosledniBod <> nil then PosledniBod^.HoleIn := HoleIn;
  If PosledniBod <> nil then PosledniBod^.HoleOut := HoleOut;
 end;

 Procedure ZpracujSpoj(Zaznam : String);
 var I,Cnt: Byte;
     Index1, Index2: Word;
     Bod1, Bod2: BodPtr;
     Attr: Byte;
     Width: Sour;
     ValCode: Integer;
 begin {Zaznam: 1:4(128,1000) }
  I:=1; Cnt:=0;
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Index1, ValCode);
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Index2, ValCode);
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Attr, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.'],Zaznam,I,Cnt), Width, ValCode);
  HledejBodIndex(Bod1,Index1);
  HledejBodIndex(Bod2,Index2);
  VytvorSpojB(PosledniSpoj,Bod1,Bod2);
  If PosledniSpoj <> nil then PosledniSpoj^.Attr := Attr;
  If PosledniSpoj <> nil then PosledniSpoj^.Width := Width;
 end;

 Procedure ZpracujObrys(Zaznam : String);
 var I,Cnt:Byte;
     X,Y:Sour;
     ValCode:Integer;
 begin       {Celek: 90.0,-74.0;103.0,-1.0;122.0,-69.0;116.0,-6.0;127.0,-57.0; }
  I:=1; Cnt:=0;  { 90.0,-74.0 }
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), X, ValCode);
  Filtruj([#0..#255] - ['0'..'9','.','-'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.','-'],Zaznam,I,Cnt), Y, ValCode);
  If FVerze = 1 then
   begin
    X:=X*1000; // prepocet kvuli novym souradnicim
    Y:=Y*1000;
   end;
  VytvorCaru(PosledniUzel,PosledniObrys,X,Y);
 end;

 Procedure ZpracujNazev(Zaznam : String);
 begin
  PosledniNazev^:=Zaznam;
 end;

 Procedure ZpracujAtribut(Zaznam : string);
 var I, Cnt: Byte;
     Attr: Longint;
     ValCode:Integer;
 begin
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), Attr, ValCode);
  If (Attr >= 0) AND (Attr <=255) AND (PosledniAtribut <> nil) then
   PosledniAtribut^:= Attr;
 end;

 Procedure ZpracujJednotky(Zaznam : String);
 var I,Cnt: Byte;
     ValCode: Integer;
 begin
  I:=1; Cnt:=0;  { 1000.0 }
  Filtruj([#0..#255] - ['0'..'9','.'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9','.'],Zaznam,I,Cnt), FUnitsInPixel, ValCode);
 end;

 Procedure ZpracujVerzi(Zaznam : String);
 var I,Cnt:Byte;
     ValCode:Integer;
 begin
  I:=1; Cnt:=0;  { 2 }
  Filtruj([#0..#255] - ['0'..'9'],Zaznam,I,Cnt);
  Val(Filtruj(['0'..'9'],Zaznam,I,Cnt), FVerze, ValCode);
 end;

 {Procedury ke cteni ze souboru}
 Procedure PrectiSlovo(var Slovo : String; var Kod : Byte);
  var R : Char;
  begin
   Slovo := '';
   Repeat Read(T,R); Until (R IN PovoleneZnaky + ['<','>',';'] - [' ']) OR Eof(T);
   While NOT ((R IN ['<','>'] + Oddelovace) OR Eof(T)) do
    begin
     If R IN PovoleneZnaky then Slovo := Slovo + R;
     Read(T,R);
    end;
   If (R = '<') OR (R IN Oddelovace) then Kod := kodObsah;
   If (R = '>') then Kod := kodElement;
   If Slovo = '' then Kod := 0;
   If Eof(T) then Kod := kodEof;
  end;

 Procedure ZpracujObsah(Element, Zaznam : String);
 begin
  If Element = ElNazev then ZpracujNazev(Zaznam);
  If Element = ElBody then ZpracujBod(Zaznam);
  If Element = ElSpoje then ZpracujSpoj(Zaznam);
  If Element = ElObrys then ZpracujObrys(Zaznam);
  If Element = ElVerze then ZpracujVerzi(Zaznam);
  If Element = ElUnit then ZpracujJednotky(Zaznam);
  If Element = ElAttr then ZpracujAtribut(Zaznam);
 end;

 Procedure DalsiZaznam(OtevrenyElement : String);
  var Slovo : String;
      Kod : Byte;
  begin
   Repeat
    PrectiSlovo(Slovo, Kod);
    If Kod = KodObsah then ZpracujObsah(OtevrenyElement,Slovo);
    If Kod = KodElement then
      If Slovo = ElClose + OtevrenyElement then Kod := KodZavritElement else
       begin
        If Slovo = ElCuprex then PosledniNazev:=@FNazev;{nasledujici nazev bude nazev cuprexu}
        If Slovo = ElSkupina then
         begin {Vytvoreni podskupiny na skupine}
          PosledniNadSkupina := PosledniSkupina;
          VytvorPodSkupinu(PosledniSkupina, PosledniNadSkupina);
          If PosledniSkupina <> nil then
           begin
            PosledniNazev := @PosledniSkupina^.Nazev;
            PosledniAtribut := @PosledniSkupina^.Attr;
           end;
         end;
        If Slovo = ElObrys then
         begin
          VytvorObrys(PosledniObrys, PosledniSkupina);
          If PosledniObrys <> nil then PosledniAtribut := @PosledniObrys^.Attr;
         end;
        DalsiZaznam(Slovo);
        If Slovo = ElSkupina then
         begin
          PosledniSkupina:=PosledniNadSkupina;
          If PosledniNadSkupina <> nil then PosledniNadSkupina:=PosledniNadSkupina^.Master;
         end;
      end;
   Until (Kod = KodEof) OR (Kod = KodZavritElement);
  end;

Begin
 FVerze := 1;
 PosledniSkupina := nil;
 PosledniNadSkupina := nil;
 PosledniBod := nil;
 PosledniSpoj := nil;
 PosledniObrys := nil;
 PosledniUzel := nil;
 PosledniNazev := @FNazev;
 PosledniAtribut := nil;
 If FileExists(Soubor) then
  begin {existujici soubor}
   AssignFile(T,Soubor);
   {$I-}
   Reset(T);
   {$I+}
   if IOResult = 0 then
     begin
      DalsiZaznam('');
      Close(T);
     end
    else
      MessageDlg('Soubor "'+Soubor+'" se nepodarilo nacist.', mtWarning, [mbOk], 0);
  end
  else begin {novy soubor...}
   ShowMessage('Vytvoren cuprex, ktery bude ulozen jako: '+#13+Soubor);
  end;
 FSoubor := Soubor;
 FModified := FALSE;
end;

Procedure TCuprex.SaveToFile (Soubor : string);
 Function SourNaStr(X : Sour) : String;
 var Sint, Sfr : String[11];
     Lint, Lfr : Longint;
 begin
  Lint:=Trunc(X);
  Lfr:=Abs(Round(Frac(X)*100000));
  Str(Lint,Sint);
  Str(Lfr,Sfr);
  SourNaStr:=Sint + '.' + Sfr;
 end;

 Procedure ZapisNazev(var T : Text; Nazev : TNazev; Mezery : String);
  begin
   Write(T, Mezery,'<',ElNazev,'>'); Write(T,Nazev); WriteLn(T,'<',ElClose,ElNazev,'>');
  end;

 Procedure ZapisVerzi(var T : Text; Mezery : String);
  begin
   WriteLn(T, Mezery+'<'+ElVerze+'>'+IntToStr(FVerze)+'<'+ElClose+ElVerze+'>');
  end;

 Procedure ZapisJednotky(var T : Text; Mezery : String);
  begin
   WriteLn(T, Mezery+'<'+ElUnit+'>'+SourNaStr(FUnitsInPixel)+'<'+ElClose+ElUnit+'>');
  end;

 Procedure ZapisAtribut(var T : Text; Attr : Byte; Mezery : String);
  begin
   WriteLn(T, Mezery+'<'+ElAttr+'>',Attr,'<'+ElClose+ElAttr+'>');
  end;

 Procedure ZapisObrys(var T : Text; Obrys : ObrysPtr; Mezery : String);
  var TempUzel : UzelPtr;
  begin
   WriteLn(T, Mezery,'<',ElObrys,'>');
   ZapisAtribut(T, Obrys^.Attr, Mezery + ' ');
   Write(T, Mezery+' ');
   TempUzel := Obrys^.HlavniUzel;
   While TempUzel <> nil do
    begin
     Write(T, SourNaStr(TempUzel^.X),',',SourNaStr(TempUzel^.Y));
     If TempUzel^.Dalsi = nil then WriteLn(T, ';') else Write(T, ';');
     TempUzel:=TempUzel^.Dalsi;
    end;
   WriteLn(T, Mezery,'<',ElClose,ElObrys,'>');
  end;

 Procedure ZapisObrysy(var T : Text; Skupina : SkupinaPtr; Mezery : String);
  var TempObrys : ObrysPtr;
  begin
   TempObrys:=HlavniObrys;
   While TempObrys <> nil do
    begin
     If TempObrys^.Master = Skupina then ZapisObrys(T,TempObrys,Mezery+' ');
     TempObrys:=TempObrys^.Dalsi;
    end;
  end;

 Procedure ZapisVsechnySpoje(var T : Text; Mezery : String);
  var TempSpoj : SpojPtr;
  begin
     WriteLn(T, Mezery,'<',ElSpoje,'>');
     TempSpoj:=HlavniSpoj;
     While TempSpoj <> nil do
      begin
       WriteLn(T, Mezery+' ',TempSpoj^.Zacatek^.Index,':',TempSpoj^.Konec^.Index,
                      '(',TempSpoj^.Attr,',',SourNaStr(TempSpoj^.Width),');');
       TempSpoj := TempSpoj^.Dalsi;
      end;
     WriteLn(T, Mezery,'<',ElClose,ElSpoje,'>');
  end;

 Procedure ZapisVsechnyBody(var T : Text; Skupina : SkupinaPtr; Mezery : String);
  var TempBod : BodPtr;
  begin
     WriteLn(T,Mezery,'<',ElBody,'>');
     TempBod:=HlavniBod;
     While TempBod <> nil do
      begin
       If TempBod^.Master = Skupina then
        WriteLn(T,Mezery+' ',TempBod^.Index,'(',SourNaStr(TempBod^.X),',',SourNaStr(TempBod^.Y),',',
                  SourNaStr(TempBod^.HoleIn),',',SourNaStr(TempBod^.HoleOut),TempBod^.Attr,');');
       TempBod := TempBod^.Dalsi;
      end;
     WriteLn(T,Mezery,'<',ElClose,ElBody,'>');
  end;

 Procedure ZapisVsechnySkupiny(var T : Text; Skupina : SkupinaPtr; Mezery : String);
  begin
   While Skupina <> nil do
    begin
     WriteLn(T,Mezery,'<',elSkupina,'>');
      ZapisNazev(T, Skupina^.Nazev, Mezery + ' ');
      ZapisAtribut(T, Skupina^.Attr, Mezery + ' ');
      ZapisVsechnyBody(T, Skupina, Mezery + ' ');
      ZapisObrysy(T, Skupina, Mezery + ' ');
      ZapisVsechnySkupiny(T, Skupina^.Sub, Mezery + ' ');
     WriteLn(T,Mezery,'<',elClose,elSkupina,'>');
     Skupina:=Skupina^.Dalsi;
    end;
  end;

 Procedure OcislujBody;
  var TempBod : BodPtr;
      Index : Word;
  begin
     TempBod:=HlavniBod;
     Index:=1;
     While TempBod <> nil do
      begin
       TempBod^.Index:=Index;
       Inc(Index);
       TempBod:=TempBod^.Dalsi;
      end;
  end;

var T: Text;
    Zapsat: Boolean;
begin
 FVerze := 2;
 Zapsat := TRUE;
 If FileExists(Soubor) then
  Zapsat := (MessageDlg('Soubor "'+Soubor+'" existuje, prepsat ?',mtConfirmation,[mbYes,mbNo],0) = mrYes);
 If Zapsat then
  begin
   OcislujBody;
   AssignFile (T,Soubor);
   {$I-}
   ReWrite(T);
   {$I+}
   if IOResult = 0 then
    begin
     WriteLn(T,'<',ElCuprex,'>');
      ZapisNazev(T,FNazev,' ');
      ZapisVerzi(T,' ');
      ZapisJednotky(T,' ');
      ZapisVsechnySkupiny(T,HlavniSkupina,' ');
      ZapisVsechnySpoje(T,' ');
     WriteLn(T,'<',ElClose,ElCuprex,'>');
     Close(T);
     FModified := FALSE;
     MessageDlg('Soubor "'+ Soubor +'" byl ulozen.', mtInformation, [mbOk], 0);
    end
   else
     MessageDlg('Neni mozne vytvorit soubor "'+ Soubor +'"', mtWarning, [mbOk], 0);
  end;
end;

Destructor TCuprex.Destroy;
begin
 If TCuprex <> nil then
  begin
   {Zruseni spoju}  ZrusVsechnySpoje(HlavniSpoj);
   {Zruseni bodu}   ZrusVsechnyBody(HlavniBod);
   {Zruseni obrysu} ZrusVsechnyObrysy(HlavniObrys);
   {Zruseni skupin} ZrusVsechnySkupiny(HlavniSkupina);
   inherited Destroy;
  end;
end;

Function TCuprex.GetHlavniSpoj : SpojPtr;
begin
 GetHlavniSpoj := HlavniSpoj;
end;

Function TCuprex.GetHlavniBod : BodPtr;
begin
 GetHlavniBod := HlavniBod;
end;

Function TCuprex.GetHlavniSkupina : SkupinaPtr;
begin
 GetHlavniSkupina := HlavniSkupina;
end;

Function TCuprex.GetHlavniObrys : ObrysPtr;
begin
 GetHlavniObrys := HlavniObrys;
end;

Function TCuprex.GetSoubor : String;
begin
 GetSoubor := FSoubor;
end;

Function TCuprex.GetNazev : String;
begin
 GetNazev := FNazev;
end;

Function TCuprex.GetPocetBodu : Integer;
begin
 GetPocetBodu := FPocetBodu;
end;

Function TCuprex.GetPocetSpoju : Integer;
begin
 GetPocetSpoju := FPocetSpoju;
end;

Function TCuprex.GetPocetObrysu : Integer;
begin
 GetPocetObrysu := FPocetObrysu;
end;

Function TCuprex.GetPocetCar : Integer;
begin
 GetPocetCar := FPocetCar;
end;

Function TCuprex.GetPocetSkupin : Integer;
begin
 GetPocetSkupin := FPocetSkupin;
end;

Function TCuprex.Modified : Boolean;
begin
 Modified := FModified;
end;

Procedure TCuprex.VytvorBod(var Bod : BodPtr; Skupina : SkupinaPtr; X, Y : Sour; Index : Word);
var NovyBod: BodPtr;
begin
  NovyBod := nil;
  New(NovyBod); Inc(FPocetBodu);
  NovyBod^.X := X;
  NovyBod^.Y := Y;
  NovyBod^.Stupen := 0;
  NovyBod^.Index := Index;
  NovyBod^.Attr := defAttrBod;
  NovyBod^.HoleOut := defHoleOut;
  NovyBod^.HoleIn := defHoleIn;
  NovyBod^.Master := Skupina;
  NovyBod^.Dalsi := HlavniBod;
  If NovyBod^.Dalsi <> nil then NovyBod^.Dalsi^.Predchozi:=NovyBod;
  NovyBod^.Predchozi:=nil;
  HlavniBod:=NovyBod;
  Bod := NovyBod;
end;

Procedure TCuprex.VytvorSpojB (var Spoj : SpojPtr; Bod1, Bod2 : BodPtr);
var NovySpoj: SpojPtr;
begin
 NovySpoj := nil;
 If (Bod1 <> nil) AND (Bod2 <> nil) then
  begin
   New(NovySpoj); Inc(FPocetSpoju);
   NovySpoj^.Zacatek := Bod1; Inc(Bod1^.Stupen);
   NovySpoj^.Konec := Bod2; Inc(Bod2^.Stupen);
   NovySpoj^.Dalsi := HlavniSpoj;
   NovySpoj^.Attr := defAttrSpoj;
   NovySpoj^.Width := defWidthSpoj;
   If NovySpoj^.Dalsi <> nil then NovySpoj^.Dalsi^.Predchozi := NovySpoj;
   NovySpoj^.Predchozi := nil;
   HlavniSpoj:=NovySpoj;
  end;
 Spoj:=NovySpoj;
end;

Procedure TCuprex.VytvorCaru(var Uzel : UzelPtr; var Obrys : ObrysPtr; X, Y : Sour);
var NovaUzel: UzelPtr;
begin
 NovaUzel := nil;
 If Obrys <> nil then
  begin
   New(NovaUzel); Inc(FPocetCar);
   NovaUzel^.X:=X;
   NovaUzel^.Y:=Y;
   NovaUzel^.Master:=Obrys;
   NovaUzel^.Predchozi:=nil;
   NovaUzel^.Dalsi:=Obrys^.HlavniUzel;
   If Obrys^.HlavniUzel <> nil then Obrys^.HlavniUzel^.Predchozi:=NovaUzel;
   Obrys^.HlavniUzel:=NovaUzel;
  end;
 Uzel := NovaUzel;
end;

Procedure TCuprex.VytvorObrys(var Obrys : ObrysPtr; NadSkupina : SkupinaPtr);
var NovyObrys: ObrysPtr;
begin
  NovyObrys := nil;
  New(NovyObrys); Inc(FPocetObrysu);
  NovyObrys^.Master := NadSkupina;
  NovyObrys^.HlavniUzel := nil;
  NovyObrys^.Attr := defAttrObrys;
  NovyObrys^.Predchozi := nil;
  NovyObrys^.Dalsi := HlavniObrys;
  If NovyObrys^.Dalsi <> nil then NovyObrys^.Dalsi^.Predchozi := NovyObrys;
  HlavniObrys := NovyObrys;
  Obrys := NovyObrys;
end;

Procedure TCuprex.VytvorPodSkupinu(var Skupina : SkupinaPtr; NadSkupina : SkupinaPtr);
var NovaSkupina: SkupinaPtr;
begin
  NovaSkupina := nil;
  New(NovaSkupina); Inc(FPocetSkupin);
  NovaSkupina^.Nazev := 'Nova skupina';
  NovaSkupina^.Attr := defAttrSkupina;
  NovaSkupina^.Master := NadSkupina;
  NovaSkupina^.Sub := nil;
  NovaSkupina^.Predchozi := nil;
  If NadSkupina <> nil then
   begin
    NovaSkupina^.Dalsi := NadSkupina^.Sub;
    NadSkupina^.Sub := NovaSkupina;
    If NovaSkupina^.Dalsi <> nil then NovaSkupina^.Dalsi^.Predchozi:=NovaSkupina;
   end else
   begin
    NovaSkupina^.Dalsi := HlavniSkupina;
    If HlavniSkupina <> nil then HlavniSkupina^.Predchozi:=NovaSkupina;
    HlavniSkupina:=NovaSkupina;
   end;
  Skupina := NovaSkupina;
end;


Procedure TCuprex.ZrusBod(var Bod : BodPtr);
var Predchozi, Dalsi: BodPtr;
    TempSpoj, DalsiSpoj: SpojPtr;
begin
 If Bod <> nil then
  begin
   Dalsi := Bod^.Dalsi;
   Predchozi := Bod^.Predchozi;
   TempSpoj := HlavniSpoj;
   While TempSpoj <> nil do
    begin
     DalsiSpoj := TempSpoj^.Dalsi;
     If (TempSpoj^.Zacatek = Bod) OR (TempSpoj^.Konec = Bod) then ZrusSpoj(TempSpoj);
     TempSpoj := DalsiSpoj;
    end;
   Dispose(Bod); Bod:=nil; Dec(FPocetBodu); FModified := TRUE;
   If Dalsi <> nil then Dalsi^.Predchozi:=Predchozi;
   If Predchozi <> nil then Predchozi^.Dalsi:=Dalsi else HlavniBod:=Dalsi;
  end;
end;

Procedure TCuprex.ZrusSpoj(var Spoj : SpojPtr);
var Predchozi, Dalsi: SpojPtr;
begin
 If Spoj <> nil then
  begin
   Dalsi:=Spoj^.Dalsi;
   Predchozi:=Spoj^.Predchozi;
   Spoj^.Zacatek^.Stupen:=Spoj^.Zacatek^.Stupen-1;
   Spoj^.Konec^.Stupen:=Spoj^.Konec^.Stupen-1;
   Dispose(Spoj); Spoj:=nil; Dec(FPocetSpoju); FModified := TRUE;
   If Dalsi <> nil then Dalsi^.Predchozi:=Predchozi;
   If Predchozi <> nil then Predchozi^.Dalsi:=Dalsi else HlavniSpoj:=Dalsi;
  end;
end;

Procedure TCuprex.ZrusObrys(var Obrys : ObrysPtr);
var Dalsi, Predchozi: ObrysPtr;
begin
 While Obrys <> nil do
  begin
   Dalsi := Obrys^.Dalsi;
   Predchozi := Obrys^.Predchozi;
   ZrusVsechnyCary(Obrys^.HlavniUzel);
   Dispose(Obrys); Obrys:=nil; Dec(FPocetObrysu); FModified := TRUE;
   If Dalsi <> nil then Dalsi^.Predchozi:=Predchozi;
   If Predchozi <> nil then Predchozi^.Dalsi:=Dalsi else HlavniObrys:=Dalsi;
  end;
end;

Procedure TCuprex.ZrusSkupinu(var Skupina : SkupinaPtr);
 procedure ZrusObsahSkupiny(var Skupina : SkupinaPtr);
  var Dalsi, Predchozi : SkupinaPtr;
      TempPodSkupina, DalsiPodSkupina : SkupinaPtr;
      TempBod, DalsiBod : BodPtr;
      TempObrys, DalsiObrys : ObrysPtr;
  begin
   Dalsi := Skupina^.Dalsi;
   Predchozi := Skupina^.Predchozi;
   TempBod:=HlavniBod;
   While TempBod <> nil do
    begin
     DalsiBod := TempBod^.Dalsi;
     If TempBod^.Master = Skupina then ZrusBod(TempBod);
     TempBod := DalsiBod;
    end;
   TempObrys:=HlavniObrys;
   While TempObrys <> nil do
    begin
     DalsiObrys := TempObrys^.Dalsi;
     If TempObrys^.Master = Skupina then ZrusObrys(TempObrys);
     TempObrys := DalsiObrys;
    end;
   TempPodSkupina := Skupina^.Sub;
   While TempPodSkupina <> nil do
    begin
     DalsiPodSkupina := TempPodSkupina^.Dalsi;
     ZrusObsahSkupiny(TempPodSkupina);
     TempPodSkupina := DalsiPodSkupina;
    end;
   Dispose(Skupina); Skupina:=nil; Dec(FPocetSkupin); FModified := TRUE;
   If Dalsi <> nil then Dalsi^.Predchozi:=Predchozi;
   If Predchozi <> nil then Predchozi^.Dalsi:=Dalsi;
  end;

begin
 If Skupina <> nil then
  begin
   If Skupina^.Predchozi = nil then
    begin
     If Skupina^.Master = nil then HlavniSkupina := Skupina^.Dalsi
                       else Skupina^.Master^.Sub := Skupina^.Dalsi;
    end;
   ZrusObsahSkupiny(Skupina);
  end;
end;

Procedure TCuprex.RozpustSkupinu(var Skupina : SkupinaPtr);
var Dalsi, Predchozi, TempSkupina: SkupinaPtr;
    Prvni, Posledni: SkupinaPtr;
    TempBod: BodPtr;
begin
 If Skupina <> nil then
  begin
   TempBod := HlavniBod;
   While TempBod <> nil do
    begin
     If TempBod^.Master = Skupina then TempBod^.Master := Skupina^.Master;
     TempBod := TempBod^.Dalsi;
    end;
   Dalsi := Skupina^.Dalsi;
   Predchozi := Skupina^.Predchozi;
   If Skupina^.Sub <> nil then
    begin
     TempSkupina := Skupina^.Sub;
     While TempSkupina <> nil do
      begin
       TempSkupina^.Master := Skupina^.Master;
       TempSkupina := TempSkupina^.Dalsi;
      end;
     Prvni := Skupina^.Sub;
     Posledni := Skupina^.Sub;
     While Posledni^.Dalsi <> nil do Posledni := Posledni^.Dalsi;
    end else
    begin
     Prvni := Skupina^.Dalsi;
     Posledni := Skupina^.Predchozi;
    end;
   If Prvni <> nil then Prvni^.Predchozi := Predchozi;
   If Posledni <> nil then Posledni^.Dalsi := Dalsi;
   If Dalsi <> nil then Dalsi^.Predchozi := Posledni;
   If Predchozi <> nil then Predchozi^.Dalsi := Prvni else
      begin
       If HlavniSkupina = Skupina then HlavniSkupina := Prvni;
       If Skupina^.Master <> nil then
        If Skupina^.Master^.Sub = Skupina then Skupina^.Master^.Sub := Prvni;
      end;
   ShowMessage('Skupina ' + Skupina^.Nazev + ' byla rozpustena,'+ #13 +
               'HlavniSkupina je nyni: '+ HlavniSkupina^.Nazev + #13 +
               'rozpustena skupina byla vypustena z pameti.');
   Dispose(Skupina); Skupina:=nil; Dec(FPocetSkupin); FModified := TRUE;
  end;
end;

Procedure TCuprex.SjednotVybraneSkupiny;
var NovaSkupina : SkupinaPtr;
begin
{zatim nic, to chce jeste vykoumat}
end;


Procedure TCuprex.VytvorSousedniSkupinu(Sousedni : SkupinaPtr; Nazev : TNazev);
var NovaSkupina: SkupinaPtr;
begin
 If (Sousedni <> nil) OR (HlavniSkupina = nil) then
  begin
   New(NovaSkupina); Inc(FPocetSkupin); FModified := TRUE;
   NovaSkupina^.Nazev := Nazev;
   NovaSkupina^.Attr := defAttrSkupina;
   NovaSkupina^.Sub := nil;
   If Sousedni <> nil then
    begin
     NovaSkupina^.Master := Sousedni^.Master;
     NovaSkupina^.Predchozi := Sousedni;
     NovaSkupina^.Dalsi := Sousedni^.Dalsi;
     If Sousedni^.Dalsi <> nil then Sousedni^.Dalsi^.Predchozi := NovaSkupina;
     Sousedni^.Dalsi := NovaSkupina;
    end else
    begin
     NovaSkupina^.Master := nil;
     NovaSkupina^.Predchozi := nil;
     NovaSkupina^.Dalsi := nil;
     HlavniSkupina := NovaSkupina;
    end;
  end;
end;
{
Procedure ZrusPrazdneBody(Cuprex : CuprexPtr);
var TempBod, Dalsi : BodPtr;
begin
 TempBod:=Cuprex^.HlavniBod; SetColor(10);
 While TempBod <> nil do
  begin
   Dalsi := TempBod^.Dalsi;
   If TempBod^.Stupen = 0 then ZrusBod(TempBod,Cuprex);
   TempBod := Dalsi;
  end;
end;
}

Procedure TCuprex.RozdelSpoj(var Spoj : SpojPtr; Skupina : SkupinaPtr; Xp, Yp : Sour);
var Zacatek, Stred, Konec : BodPtr;
    X0, Y0, Xt, Yt, ux, uy : Sour;
    t : Real;
    Spoj1, Spoj2 : SpojPtr;
begin
 If Spoj <> nil then
  begin
   Zacatek := Spoj^.Zacatek;
   Konec := Spoj^.Konec;
   X0:=Zacatek^.X;
   Y0:=Zacatek^.Y;
   ux:=Konec^.X - Zacatek^.X;
   uy:=Konec^.Y - Zacatek^.Y;
   If ux+uy <> 0 then
    begin
     t:=(-1)*(ux*(X0-Xp)+uy*(Y0-Yp))/(ux*ux+uy*uy);
     If T>1 then T:=1;
     If T<0 then T:=0;
     Xt:=X0+Round(ux*t);
     Yt:=Y0+Round(uy*t);
    end;
   ZrusSpoj(Spoj);
   VytvorBod(Stred, Skupina, Xt, Yt, 0);
   VytvorSpojB(Spoj1, Zacatek, Stred);
   VytvorSpojB(Spoj2, Stred, Konec);
  end;
end;

Procedure TCuprex.OznacBod(const Bod : BodPtr);
begin
 If Bod <> nil then Bod^.Attr := Bod^.Attr OR caSelected;
end;

Procedure TCuprex.OznacJedenBod(const Bod : BodPtr);
var TempBod: BodPtr;
begin
 TempBod := HlavniBod;
  While TempBod <> nil do {odznac vsechny}
   begin
    TempBod^.Attr := TempBod^.Attr AND NOT caSelected;
    TempBod := TempBod^.Dalsi;
   end;                   {oznac vybrany}
 OznacBod(Bod);
end;

Procedure TCuprex.OznacSpoj(const Spoj : SpojPtr);
begin
 If Spoj <> nil then Spoj^.Attr := Spoj^.Attr OR caSelected;
end;

Procedure TCuprex.OznacJedenSpoj(const Spoj : SpojPtr);
var TempSpoj: SpojPtr;
begin
 TempSpoj:=HlavniSpoj;
  While TempSpoj <> nil do {odznac vsechny}
   begin
    TempSpoj^.Attr := TempSpoj^.Attr AND NOT caSelected;
    TempSpoj := TempSpoj^.Dalsi;
   end;                    {oznac vybrany}
 OznacSpoj(Spoj);
end;

Procedure TCuprex.OznacVetev(const Spoj : SpojPtr);
 procedure OznacDalsi(Bod : BodPtr);
 var TempSpoj: SpojPtr;
 begin
  TempSpoj := HlavniSpoj;
  While TempSpoj <> nil do
   begin
    If (TempSpoj^.Attr AND caSelected) = 0 then
     begin
      If TempSpoj^.Zacatek = Bod then
       begin OznacSpoj(TempSpoj); OznacDalsi(TempSpoj^.Konec); end;
      If TempSpoj^.Konec = Bod then
       begin OznacSpoj(TempSpoj); OznacDalsi(TempSpoj^.Zacatek); end;
     end;
    TempSpoj := TempSpoj^.Dalsi;
   end;
 end;
var TempSpoj: SpojPtr;
begin
 TempSpoj:=HlavniSpoj;
  While TempSpoj <> nil do {odznac vsechny}
   begin
    TempSpoj^.Attr := TempSpoj^.Attr AND NOT caSelected;
    TempSpoj := TempSpoj^.Dalsi;
   end;
 If Spoj <> nil then
  begin
   OznacDalsi(Spoj^.Zacatek);
   OznacDalsi(Spoj^.Konec);
  end;
end;

Procedure TCuprex.OznacObrys(const Obrys : ObrysPtr);
begin
 If Obrys <> nil then Obrys^.Attr := Obrys^.Attr OR caSelected;
end;

Procedure TCuprex.OznacJedenObrys(const Obrys : ObrysPtr);
var TempObrys : ObrysPtr;
    TempUzel : UzelPtr;
begin
 TempObrys := HlavniObrys;
 While TempObrys <> nil do
  begin
   TempObrys^.Attr := TempObrys^.Attr AND NOT caSelected;
   TempObrys := TempObrys^.Dalsi;
  end;
 OznacObrys(Obrys);
end;

Procedure TCuprex.SetWidthToSelected(Width : Sour);
var TempSpoj : SpojPtr;
begin
 TempSpoj := HlavniSpoj;
 While TempSpoj <> nil do
  begin
   If TempSpoj^.Attr AND caSelected = caSelected then TempSpoj^.Width := Width;
   TempSpoj := TempSpoj^.Dalsi;
  end;
end;

Procedure TCuprex.SetHoleInToSelected(HoleIn : Sour);
var TempBod : BodPtr;
begin
 TempBod := HlavniBod;
 While TempBod <> nil do
  begin
   If TempBod^.Attr AND caSelected = caSelected then TempBod^.HoleIn := HoleIn;
   TempBod := TempBod^.Dalsi;
  end;
end;

Procedure TCuprex.SetHoleOutToSelected(HoleOut : Sour);
var TempBod : BodPtr;
begin
 TempBod := HlavniBod;
 While TempBod <> nil do
  begin
   If TempBod^.Attr AND caSelected = caSelected then TempBod^.HoleOut := HoleOut;
   TempBod := TempBod^.Dalsi;
  end;
end;

Procedure TCuprex.ZrusVsechnyBody(var Bod : BodPtr);
var Dalsi: BodPtr;
begin
 While Bod <> nil do
  begin
   Dalsi := Bod^.Dalsi;
   Dispose(Bod); Bod:=nil; Dec(FPocetBodu);
   Bod := Dalsi;
  end;
end;

Procedure TCuprex.ZrusVsechnySpoje(var Spoj : SpojPtr);
var Dalsi: SpojPtr;
begin
 While Spoj <> nil do
  begin
   Dalsi := Spoj^.Dalsi;
   Dispose(Spoj); Spoj:=nil; Dec(FPocetSpoju);
   Spoj := Dalsi;
  end;
end;

Procedure TCuprex.ZrusVsechnySkupiny(var Skupina : SkupinaPtr);
var Dalsi: SkupinaPtr;
begin
 While Skupina <> nil do
  begin
   Dalsi:=Skupina^.Dalsi;
   ZrusVsechnySkupiny(Skupina^.Sub);
   Dispose(Skupina); Skupina:=nil; Dec(FPocetSkupin);
   Skupina:=Dalsi;
  end;
end;

Procedure TCuprex.ZrusVsechnyCary(var Uzel : UzelPtr);
var Dalsi: UzelPtr;
begin
 If Uzel <> nil then
  begin
   While Uzel <> nil do
    begin
     Dalsi:=Uzel^.Dalsi;
     Dispose(Uzel); Uzel:=nil; Dec(FPocetCar);
     Uzel:=Dalsi;
    end;
  end;
end;

Procedure TCuprex.ZrusVsechnyObrysy(var Obrys : ObrysPtr);
var Dalsi: ObrysPtr;
begin
 While Obrys <> nil do
  begin
   Dalsi := Obrys^.Dalsi;
   ZrusVsechnyCary(Obrys^.HlavniUzel);
   Dispose(Obrys); Obrys:=nil; Dec(FPocetObrysu);
   Obrys := Dalsi;
  end;
end;

Procedure TCuprex.HledejBodIndex(var Bod : BodPtr; Index : Word);
var TempBod: BodPtr;
begin
  Bod:=nil;
  TempBod:=HlavniBod;
  While TempBod <> nil do
   begin
    If TempBod^.Index = Index then Bod := TempBod;
    TempBod := TempBod^.Dalsi;
   end;
end;

end.
