{ Lukas Cerovsky - semestralni prace}
{ Formular vypisoveho okna}

unit CuprexEditor;

interface

uses SysUtils, Windows, Classes, Graphics, Forms, Controls,
     CuprexTypes, CuprexDataClass, CuprexCanvasWriter, CuprexKeyConst, CuprexPohled,
     CuprexPohledAsistent,
     ComCtrls, ToolWin, Buttons, Dialogs, StdCtrls;

type
  TCuprexEditorForm = class(TForm)
    TreeView: TTreeView;
    StatusBar: TStatusBar;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormActivate(Sender: TObject);
    procedure UpdateTreeView;
    procedure UpdateStatusBar;
    procedure TreeViewEdited(Sender: TObject; Node: TTreeNode; var S: String);
    procedure TreeViewExpanded(Sender: TObject; Node: TTreeNode);
    procedure TreeViewCollapsed(Sender: TObject; Node: TTreeNode);
    procedure UpdateBtnClick(Sender: TObject);
    procedure DeleteBtnClick(Sender: TObject);
    procedure DissolveBtnClick(Sender: TObject);
    procedure TreeViewKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure CreateBtnClick(Sender: TObject);
    procedure PohledBtnClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure SloucitBtnClick(Sender: TObject);
   private
    FMyCuprex : TCuprex;
    FMyCanvasWriter : TCanvasWriter;
    FMyPohledAsistent : TCuprexPohledAsistent;
     { Private declarations }
   public
    constructor CreateFromFile(Soubor : string; AOwner : TComponent);
    function GetMyCuprex : TCuprex;
    procedure SaveToFile(soubor : string);
    { Public declarations }
  end;

implementation

{$R *.DFM}


Constructor TCuprexEditorForm.CreateFromFile(Soubor : string; AOwner : TComponent);
begin
  Create(AOwner);
  FMyCuprex := TCuprex.CreateFromFile(Soubor);
  FMyCanvasWriter := TCanvasWriter.CreateOnCuprex(FMyCuprex);
  FMyPohledAsistent := TCuprexPohledAsistent.CreateOnCanvasWriter(FMyCanvasWriter);
  Caption := ExtractFileName(Soubor) + ' (' + FMyCuprex.GetNazev + ')';
  UpdateTreeView;
end;

procedure TCuprexEditorForm.FormActivate(Sender: TObject);
begin
{ If (MainCaption <> nil)AND(FMyCuprex <> nil) then
 //to bylo kvuli MAIN, aby si aktualizoval data
   MAINCaption^ := 'winCuprex - ' + FMyCuprex.GetSoubor;}
end;

procedure TCuprexEditorForm.FormDestroy(Sender: TObject);
begin
  FMyCanvasWriter.Destroy;
  FMyCuprex.Destroy;
  FMyPohledAsistent.Destroy;
end;

procedure TCuprexEditorForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
end;

Procedure TCuprexEditorForm.UpdateTreeView;
var I : Integer;
   AktivniSkupina : SkupinaPtr;
 Procedure OpisSkupiny(NadPolozka : TTreeNode; Skupina : SkupinaPtr);
  var Polozka : TTreeNode;
  begin
   While Skupina <> nil do
    begin
     If NadPolozka <> nil then
      begin
       Polozka := TreeView.Items.AddChildObject(NadPolozka, Skupina^.Nazev, Skupina);
      { If Polozka.Data = nil then Polozka.Text := Polozka.Text + ' -> nil';}
      { If Polozka.Data = Skupina then Polozka.Text := Polozka.Text + ' -> Skupina';}
       Inc(I);
      end
     else
      begin
       Polozka := TreeView.Items.AddObject(nil, Skupina^.Nazev, Skupina);
       Inc(I);
      end;
     If Skupina = nil then ShowMessage('Nekdo mi behem nacitani smazal skupinu !')
      else
     //skupina = nil, (asi) jak to ? Ne nil, ale nejaka cizi adresa.
     OpisSkupiny(Polozka, Skupina^.Sub);
     Polozka.Expanded := (Skupina^.Attr AND caExpanded) = caExpanded;
     If (Skupina^.Attr AND caSelected) = caSelected then
          Polozka.Text:= ' '+Polozka.Text else Polozka.Text:=Skupina^.Nazev;
     If (AktivniSkupina <> nil) AND (AktivniSkupina = Skupina) then Polozka.Selected:=TRUE;
     Skupina:=Skupina^.Dalsi;
    end;
  end;

 var Node : TTreeNode;
begin
  I:=0; AktivniSkupina:=nil;
  Node := TreeView.Selected;
  If Node <> nil then AktivniSkupina := Node.Data;
  TreeView.Hide;
  TreeView.Items.Clear;
// read of adress $FFFFFFFF, proc ? GetHlavniSkupina ukazuje na zruseny zaznam
  If FMyCuprex <> nil then OpisSkupiny(nil, FMyCuprex.GetHlavniSkupina);
  TreeView.Show;
  If AktivniSkupina <> nil then TreeView.SetFocus;
  StatusBar.Panels.Items[4].Text := IntToStr(I) + ' nactenych';
end;

Procedure TCuprexEditorForm.UpdateStatusBar;
begin
  StatusBar.Panels.Items[0].Text := IntToStr(FMyCuprex.GetPocetBodu) + ' bodu';
  StatusBar.Panels.Items[1].Text := IntToStr(FMyCuprex.GetPocetSpoju) + ' spoju';
  StatusBar.Panels.Items[2].Text := IntToStr(FMyCuprex.GetPocetObrysu) + ' obrysu';
  StatusBar.Panels.Items[3].Text := IntToStr(FMyCuprex.GetPocetSkupin) + ' skupin';
end;

Function TCuprexEditorForm.GetMyCuprex : TCuprex;
begin
  GetMyCuprex := FMyCuprex;
end;

Procedure TCuprexEditorForm.SaveToFile(Soubor : string);
begin
  If Soubor = '' then Soubor := FMyCuprex.GetSoubor;
  FMyCuprex.SaveToFile(Soubor);
  Caption := ExtractFileName(Soubor) + ' (' + FMyCuprex.GetNazev + ')';
end;

procedure TCuprexEditorForm.TreeViewEdited(Sender: TObject;
  Node: TTreeNode; var S: String);
 var Skupina : SkupinaPtr;
begin
 Skupina := Node.Data;
 If Skupina <> nil then Skupina^.Nazev := S;
{ UpdateTreeView; tohle tu nesmi byt, protoze to leze do treeviewu}
end;

procedure TCuprexEditorForm.TreeViewExpanded(Sender: TObject; Node: TTreeNode);
 var Skupina : SkupinaPtr;
begin {vola se i pri primem nastaveni Node.Expanded:=TRUE}
 If Node <> nil then
  begin
   Skupina := Node.Data;
   If Skupina <> nil then Skupina^.Attr := Skupina^.Attr OR caExpanded;
  end;
end;

procedure TCuprexEditorForm.TreeViewCollapsed(Sender: TObject; Node: TTreeNode);
 var Skupina : SkupinaPtr;
begin {vola se i pri primem nastaveni Node.Expanded:=FALSE}
 If Node <> nil then
  begin
   Skupina := Node.Data;
   If Skupina <> nil then Skupina^.Attr := Skupina^.Attr AND NOT caExpanded;
  end;
end;

procedure TCuprexEditorForm.UpdateBtnClick(Sender: TObject);
begin
 UpdateTreeView;
 FMyPohledAsistent.PrekresliPohledy;
end;

procedure TCuprexEditorForm.DeleteBtnClick(Sender: TObject);
 var Skupina : SkupinaPtr;
     Node : TTreeNode;
begin
 Node := TreeView.Selected;
 If Node <> nil then
  begin
   Skupina := Node.Data;
   If Skupina <> nil then FMyCuprex.ZrusSkupinu(Skupina);
   Node.Data := nil; // Node se stejne smaze, ale pro jistotu...
   TreeView.Items.Delete(Node);
   UpdateStatusBar;
   FMyPohledAsistent.PrekresliPohledy;
  end;
end;

procedure TCuprexEditorForm.DissolveBtnClick(Sender: TObject);
 var Skupina : SkupinaPtr;
     Node : TTreeNode;
begin
 Node := TreeView.Selected;
 If Node <> nil then
  begin
   Skupina := Node.Data;
   If Skupina <> nil then FMyCuprex.RozpustSkupinu(Skupina);
   Node.Data := nil;
   UpdateTreeView; {pomoci metod Add a Delete by to bylo slozitejsi}
   UpdateStatusBar;
   FMyPohledAsistent.PrekresliPohledy;
  end;
end;

procedure TCuprexEditorForm.SloucitBtnClick(Sender: TObject);
 var Skupina : SkupinaPtr;
     Node : TTreeNode;
begin
 Node := TreeView.Selected;
 If Node <> nil then
  begin
   Skupina := Node.Data;
   If Skupina <> nil then FMyCuprex.SjednotVybraneSkupiny;
   UpdateTreeView;
   UpdateStatusBar;
   FMyPohledAsistent.PrekresliPohledy;
  end;
end;

procedure TCuprexEditorForm.CreateBtnClick(Sender: TObject);
 var Skupina : SkupinaPtr;
     Node : TTreeNode;
begin
 Node := TreeView.Selected;
 If Node <> nil then Skupina := Node.Data else Skupina := nil;
 FMyCuprex.VytvorSousedniSkupinu(Skupina,'Nova skupina');
 UpdateTreeView;
 UpdateStatusBar;
 FMyPohledAsistent.PrekresliPohledy;
end;

procedure TCuprexEditorForm.PohledBtnClick(Sender: TObject);
{var
  Pohled: TCuprexPohledForm;}
begin
  FMyPohledAsistent.NovyPohled(Self);
{  If FMyCuprex <> nil then
   begin
    Pohled := TCuprexPohledForm.CreateFromCuprex(FMyCuprex , Self);
    Pohled.SetCanvasWriter(FMyCanvasWriter);
    Pohled.Show;
   end;}
end;

procedure TCuprexEditorForm.TreeViewKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var Node : TTreeNode;
      AktualniSkupina : SkupinaPtr;
begin
 Node := TreeView.Selected;
 If Node <> nil then AktualniSkupina := Node.Data;
 Case Key of
  klDel : If ssCtrl IN Shift then
           begin
            If AktualniSkupina <> nil then FMyCuprex.ZrusSkupinu(AktualniSkupina);
            Node.Data := nil; // Node se stejne smaze, ale pro jistotu...
            TreeView.Items.Delete(Node); UpdateStatusBar;
            FMyPohledAsistent.PrekresliPohledy;
           end;
  klIns : If (Node <> nil) AND (AktualniSkupina <> nil) then
           begin
            AktualniSkupina^.Attr := AktualniSkupina^.Attr XOR caSelected;
            If (AktualniSkupina^.Attr AND caSelected) = caSelected then
             Node.Text:= ' '+Node.Text else Node.Text:=AktualniSkupina^.Nazev;
            FMyPohledAsistent.PrekresliPohledy;
           end;
  klF2  : If Node <> nil then Node.EditText;
 end;
end;

end.
