unit CuprexMAIN;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, ComCtrls,
  {CuprexPrintLayout,} CuprexDataClass;

type
  TCuprexMainForm = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    FileNewItem: TMenuItem;
    FileOpenItem: TMenuItem;
    FileCloseItem: TMenuItem;
    Window1: TMenuItem;
    Help1: TMenuItem;
    N1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    HelpAboutItem: TMenuItem;
    OpenDialog: TOpenDialog;
    FileSaveItem: TMenuItem;
    FileSaveAsItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    SpeedPanel: TPanel;
    OpenBtn: TSpeedButton;
    SaveBtn: TSpeedButton;
    StatusBar: TStatusBar;
    N2: TMenuItem;
    PrintLayoutItem: TMenuItem;
    PrintItem: TMenuItem;
    NewBtn: TSpeedButton;
    PrintBtn: TSpeedButton;
    LayoutBtn: TSpeedButton;
    PrintDialogItem: TMenuItem;
    PrintDialog: TPrintDialog;
    PohledItem: TMenuItem;
    NovyPohledItem: TMenuItem;
    TiskAktualniItem: TMenuItem;
    AktualniZavritItem: TMenuItem;
    AktualniPohledItem: TMenuItem;
    SaveDialog: TSaveDialog;
    CreateBtn: TSpeedButton;
    DeleteBtn: TSpeedButton;
    DissolveBtn: TSpeedButton;
    SloucitBtn: TSpeedButton;
    UpdateBtn: TSpeedButton;
    PohledBtn: TSpeedButton;
    procedure FormCreate(Sender: TObject);
    procedure FileNewItemClick(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems;
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileCloseItemClick(Sender: TObject);
    procedure FileOpenItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure FileSaveItemClick(Sender: TObject);
    procedure FileSaveAsItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure HelpAboutItemClick(Sender: TObject);
    procedure PrintLayoutItemClick(Sender: TObject);
    procedure ActiveFormChange(Sender: TObject);
    procedure UpdateCaption;
    procedure NovaSkupinaBtnClick(Sender: TObject);
    procedure ZrusSkupinuBtnClick(Sender: TObject);
    procedure RozpustitSkupinuBtnClick(Sender: TObject);
    procedure UpdateBtnClick(Sender: TObject);
    procedure PridatPohledBtnClick(Sender: TObject);
    procedure NovyPohledItemClick(Sender: TObject);
  private
{    ActiveCuprex : TCuprex;}
    procedure CreateMDIChild(const Soubor: string);
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  CuprexMainForm: TCuprexMainForm;
//  CuprexPrintLayoutForm: TCuprexPrintLayoutForm;

implementation

{$R *.DFM}

uses CuprexEditor;

procedure TCuprexMainForm.FormCreate(Sender: TObject);
begin
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := ActiveFormChange;
end;

procedure TCuprexMainForm.ShowHint(Sender: TObject);
begin
  StatusBar.SimpleText := Application.Hint;
end;

procedure TCuprexMainForm.ActiveFormChange(Sender: TObject);
begin
{  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
    ActiveCuprex := (ActiveMDIChild as TCuprexEditorForm).GetMyCuprex;}
  UpdateCaption;
  UpdateMenuItems;
end;

procedure TCuprexMainForm.UpdateCaption;
begin
 Caption := 'winCuprex';
{  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
    if ActiveMDIchild.WindowState = wsNormal then
     if (ActiveMDIChild as TCuprexEditorForm).GetMyCuprex <> nil then
      Caption := 'winCuprex - ' + ActiveCuprex.GetSoubor
     else Caption := 'winCuprex';}
end;

procedure TCuprexMainForm.CreateMDIChild(const Soubor: string);
var
  Child: TCuprexEditorForm;
begin
  Child := TCuprexEditorForm.CreateFromFile(Soubor ,Application);
  UpdateCaption;
end;

procedure TCuprexMainForm.FileNewItemClick(Sender: TObject);
begin
  CreateMDIChild('NONAME' + IntToStr(MDIChildCount + 1));
end;

procedure TCuprexMainForm.FileOpenItemClick(Sender: TObject);
begin
  if OpenDialog.Execute then CreateMDIChild(OpenDialog.FileName);
end;

procedure TCuprexMainForm.FileCloseItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then ActiveMDIChild.Close;
end;

procedure TCuprexMainForm.FileSaveItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).SaveToFile('');
end;

procedure TCuprexMainForm.FileSaveAsItemClick(Sender: TObject);
begin
 Savedialog.DefaultExt := 'CUP';
 if ActiveMDIChild <> nil then
  if ActiveMDIChild is TCuprexEditorForm then
   if SaveDialog.Execute then
     (ActiveMDIChild as TCuprexEditorForm).SaveToFile(SaveDialog.FileName);
end;

procedure TCuprexMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TCuprexMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TCuprexMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TCuprexMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TCuprexMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TCuprexMainForm.UpdateMenuItems;
begin
  FileCloseItem.Enabled := MDIChildCount > 0;
  FileSaveItem.Enabled := MDIChildCount > 0;
  FileSaveAsItem.Enabled := MDIChildCount > 0;
//  PrintLayoutItem.Enabled := MDIChildCount > 0;
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
  PohledItem.Enabled := ActiveMDIChild is TCuprexEditorForm;

  SaveBtn.Enabled := MDIChildCount > 0;
//  PrintBtn.Enabled := MDIChildCount > 0;
//  LayoutBtn.Enabled := MDIChildCount > 0;
  CreateBtn.Enabled := ActiveMDIChild is TCuprexEditorForm;
  DeleteBtn.Enabled := ActiveMDIChild is TCuprexEditorForm;
  DissolveBtn.Enabled := ActiveMDIChild is TCuprexEditorForm;
  UpdateBtn.Enabled := ActiveMDIChild is TCuprexEditorForm;
  PohledBtn.Enabled := ActiveMDIChild is TCuprexEditorForm;
end;

procedure TCuprexMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TCuprexMainForm.HelpAboutItemClick(Sender: TObject);
begin
//  AboutBox.ShowModal;
end;

procedure TCuprexMainForm.PrintLayoutItemClick(Sender: TObject);
begin
{ If ActiveCuprex <> nil then
 begin
  CuprexPrintLayoutForm.SetMyCuprex(ActiveCuprex);
  CuprexPrintLayoutForm.ShowModal;
 end;}
end;



procedure TCuprexMainForm.NovaSkupinaBtnClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).CreateBtnClick(Sender);
end;

procedure TCuprexMainForm.ZrusSkupinuBtnClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).DeleteBtnClick(Sender);
end;

procedure TCuprexMainForm.RozpustitSkupinuBtnClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).DissolveBtnClick(Sender);
end;

procedure TCuprexMainForm.UpdateBtnClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).UpdateBtnClick(Sender);
end;

procedure TCuprexMainForm.PridatPohledBtnClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).PohledBtnClick(Sender);
end;

procedure TCuprexMainForm.NovyPohledItemClick(Sender: TObject);
begin
  if ActiveMDIChild <> nil then
   if ActiveMDIChild is TCuprexEditorForm then
      (ActiveMDIChild as TCuprexEditorForm).PohledBtnClick(Sender);
end;

end.
