unit CuprexNahledBox;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  CuprexTypes, CuprexDataClass, CuprexCanvasWriter;

const
    MaxZoom = 1000;
    MinZoom = 10;

type
  TNahledBox = class(TGraphicControl)
   private
     FMyCanvasWriter : TCanvasWriter;
     MinX, MinY, MaxX, MaxY : Pix;
     FScale : Word;

   protected
     procedure Paint; override;

   public
     constructor Create (AOwner: TComponent); override;
     procedure SetMyCanvasWriter (CanvasWriter: TCanvasWriter);
     procedure SetScale (Scale : Word);

   published

  end;

procedure Register;

implementation

Constructor TNahledBox.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  MinX := 10;
  MinY := 10;
  MaxX := Width-10;
  MaxY := Height-10;
  FScale := 100;
  FMyCanvasWriter := nil;
end;

Procedure TNahledBox.SetMyCanvasWriter (CanvasWriter: TCanvasWriter);
begin
  if CanvasWriter <> FMyCanvasWriter then FMyCanvasWriter := CanvasWriter;
end;

Procedure TNahledBox.SetScale (Scale : Word);
begin
  FScale:=Scale;
end;


Procedure TNahledBox.Paint;
begin
 MinX := 5;
 MinY := 5;
 MaxX := Width-5;
 MaxY := Height-5;
 with Canvas do
  begin
   Pen.Color:=clRed;
   Brush.Color:=clWhite;
   Rectangle(1,1,Width-1,Height-1);
  end;
 If FMyCanvasWriter <> nil then
  begin
//   FMyCanvasWriter.SetScale(FScale);
//   FMyCanvasWriter.SetOutputArea(FPohled, MinX, MinY, MaxX, MaxY);
//   FMyCanvasWriter.CuprexNaCanvas(Canvas, FPohled);
  end;
end;

Procedure Register;
begin
  RegisterComponents('Samples', [TNahledBox]);
end;

end.
