{ Lukas Cerovsky - semestralni prace}
{ Formular pohledoveho okna}

unit CuprexPohled;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  CuprexTypes, CuprexDataClass, CuprexWorkBox, CuprexCanvasWriter, StdCtrls,
  CuprexPohledAsistent, CuprexKeyConst,
  ExtCtrls, Spin, Buttons, ComCtrls;

type
  TCuprexPohledForm = class(TInvForm)
    SpeedPanel: TPanel;
    GridBtn: TSpeedButton;
    ZoomInBtn: TSpeedButton;
    ZoomOutBtn: TSpeedButton;
    ComboBoxZoom: TComboBox;
    StatusBar: TStatusBar;
    PointNoBtn: TSpeedButton;
    PointOneBtn: TSpeedButton;
    PointAllBtn: TSpeedButton;
    EditZoom: TEdit;
    ComboBoxModul: TComboBox;
    CatchBtn: TSpeedButton;
    ViewModeBtn: TSpeedButton;
    SpojModeBtn: TSpeedButton;
    ObrysModeBtn: TSpeedButton;
    ComboTloustka: TComboBox;
    ComboHoleOut: TComboBox;
    LabelTloustka: TLabel;
    LabelDira: TLabel;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure WorkBoxChangeActive(Sender : TObject; Pohled : TPohled);
    procedure GridBtnClick(Sender: TObject);
    procedure ZoomInBtnClick(Sender: TObject);
    procedure ZoomOutBtnClick(Sender: TObject);
    procedure ComboBoxZoomChange(Sender: TObject);
    procedure EditZoomChange(Sender: TObject);
    procedure ComboBoxModulChange(Sender: TObject);
    procedure EditZoomDblClick(Sender: TObject);
    procedure ComboBoxZoomDblClick(Sender: TObject);
    procedure PointNoBtnClick(Sender: TObject);
    procedure PointOneBtnClick(Sender: TObject);
    procedure PointAllBtnClick(Sender: TObject);
    procedure CatchBtnClick(Sender: TObject);

    procedure EditZoomKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ComboBoxZoomKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure ComboBoxModulKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
    procedure FormShow(Sender: TObject);
    procedure ViewModeBtnClick(Sender: TObject);
    procedure SpojModeBtnClick(Sender: TObject);
    procedure ObrysModeBtnClick(Sender: TObject);
    procedure ComboTloustkaChange(Sender: TObject);
    procedure ComboHoleOutChange(Sender: TObject);

  private
   WorkBox: TWorkBox;
   MyPohledAsistent: TCuprexPohledAsistent;

  public
   constructor CreateByAsistent(AOwner: TComponent; Asistent: TCuprexPohledAsistent);
   procedure Prekresli; override;

  end;

implementation

{$R *.DFM}

Constructor TCuprexPohledForm.CreateByAsistent(AOwner : TComponent; Asistent : TCuprexPohledAsistent);
begin
  Create(AOwner);
  MyPohledAsistent := Asistent;
  WorkBox := TWorkBox.Create(self);
  WorkBox.Parent := self;
  WorkBox.Align := alClient;
  WorkBox.OnChangeActive := WorkBoxChangeActive;
  WorkBox.SetMyCanvasWriter(MyPohledAsistent.MyCanvasWriter);
  WorkBox.FPohledAsistent := MyPohledAsistent;
  Caption := 'Pohled: ' + MyPohledAsistent.MyCanvasWriter.FMyCuprex.GetNazev;
  ComboBoxZoom.ItemIndex := 4;
  ComboBoxModul.ItemIndex := 4;
end;

procedure TCuprexPohledForm.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
 MyPohledAsistent.ZapomenPohled(Self);
 Destroy;
end;

procedure TCuprexPohledForm.FormDestroy(Sender: TObject);
begin
 {vola se teprve po zavreni EDITORU}
end;

Procedure TCuprexPohledForm.FormShow(Sender: TObject);
begin
 WorkBox.SetFocus;
end;

Procedure TCuprexPohledForm.Prekresli;
begin
 WorkBox.Invalidate;
end;

Procedure TCuprexPohledForm.WorkBoxChangeActive(Sender : TObject; Pohled : TPohled);
begin
 StatusBar.Panels.Items[0].Text := Format('%f : %f',[Pohled.MousePos.Xpos,Pohled.MousePos.Ypos]);
 If Pohled.AktivniXYLocked then StatusBar.Panels.Items[1].Bevel := pbRaised else
                                  StatusBar.Panels.Items[1].Bevel := pbLowered;
 If (Pohled.AktivniX <> nil) AND (Pohled.AktivniY <> nil) then
   StatusBar.Panels.Items[1].Text := Format('%f : %f',[Pohled.AktivniX^,Pohled.AktivniY^]) else
   StatusBar.Panels.Items[1].Text := '- : -';
 If Pohled.AktivniSkupina <> nil then
   StatusBar.Panels.Items[2].Text :=Pohled.AktivniSkupina^.Nazev else
   StatusBar.Panels.Items[2].Text := 'Zadna skupina ve vyberu';

 ComboTloustka.Text := WorkBox.GetStrWidth;
 ComboHoleOut.Text := WorkBox.GetStrHoleOut;
 If Pohled.EditMode = emSpoje then
  begin
   ComboTloustka.Enabled := TRUE;
   ComboHoleOut.Enabled := TRUE;
  end else
  begin
   ComboTloustka.Enabled := FALSE;
   ComboHoleOut.Enabled := FALSE;
  end;
end;

procedure TCuprexPohledForm.PointNoBtnClick(Sender: TObject);
begin
 WorkBox.FPohled.PointMode := pmNo;
 WorkBox.Invalidate;
end;

procedure TCuprexPohledForm.PointOneBtnClick(Sender: TObject);
begin
 WorkBox.FPohled.PointMode := pmOne;
 WorkBox.Invalidate;
end;

Procedure TCuprexPohledForm.PointAllBtnClick(Sender: TObject);
begin
 WorkBox.FPohled.PointMode := pmAll;
 WorkBox.Invalidate;
end;

Procedure TCuprexPohledForm.GridBtnClick(Sender: TObject);
begin
 WorkBox.FPohled.FGrid.Visible := GridBtn.Down;
 WorkBox.Invalidate;
end;

Procedure TCuprexPohledForm.CatchBtnClick(Sender: TObject);
begin
 WorkBox.FPohled.FGrid.Active := CatchBtn.Down;
end;

procedure TCuprexPohledForm.ZoomInBtnClick(Sender: TObject);
var Value: Word;
begin
 Case EditZoom.Visible of
  TRUE : begin
          Value := WorkBox.FPohled.FScale; If Value < 65535 then Inc(Value);
          WorkBox.SetIntScale(Value);
          EditZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
         end;
  FALSE: begin
          If ComboBoxZoom.ItemIndex < ComboBoxZoom.Items.Count then
           ComboBoxZoom.ItemIndex := ComboBoxZoom.ItemIndex + 1;
          WorkBox.SetStrScale(ComboBoxZoom.Text);
          ComboBoxZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
         end;
 end;
end;

procedure TCuprexPohledForm.ZoomOutBtnClick(Sender: TObject);
var Value : Word;
begin
 Case EditZoom.Visible of
  TRUE : begin
          Value := WorkBox.FPohled.FScale; If Value > 0 then Dec(Value);
          WorkBox.SetIntScale(Value);
          EditZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
         end;
  FALSE: begin
          If ComboBoxZoom.ItemIndex > 0 then
           ComboBoxZoom.ItemIndex := ComboBoxZoom.ItemIndex - 1;
          WorkBox.SetStrScale(ComboBoxZoom.Text);
          ComboBoxZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
         end;
 end;
end;

Procedure TCuprexPohledForm.EditZoomDblClick(Sender: TObject);
begin
 ComboBoxZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
 EditZoom.Hide;
 ComboBoxZoom.Show;
end;

procedure TCuprexPohledForm.ComboBoxZoomDblClick(Sender: TObject);
begin
 EditZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
 ComboBoxZoom.Hide;
 EditZoom.Show;
end;

Procedure TCuprexPohledForm.ComboBoxZoomChange(Sender: TObject);
begin
 WorkBox.SetStrScale(ComboBoxZoom.Text);
end;

procedure TCuprexPohledForm.EditZoomChange(Sender: TObject);
begin
 WorkBox.SetStrScale(EditZoom.Text);
end;

procedure TCuprexPohledForm.EditZoomKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 Case Key of
  klEnter : begin
             EditZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
             WorkBox.SetFocus;
            end;
 end;
end;

procedure TCuprexPohledForm.ComboBoxZoomKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
 Case Key of
  klEnter : begin
             ComboBoxZoom.Text := IntToStr(WorkBox.FPohled.FScale) + '%';
             WorkBox.SetFocus;
            end;
 end;
end;

procedure TCuprexPohledForm.ComboBoxModulChange(Sender: TObject);
begin
 WorkBox.SetStrModul(ComboBoxModul.Text);
end;

procedure TCuprexPohledForm.ComboBoxModulKeyDown(Sender: TObject;
  var Key: Word; Shift: TShiftState);
begin
 Case Key of
  klEnter : begin
             ComboBoxModul.Text := WorkBox.GetStrModul;
             WorkBox.SetFocus;
            end;
 end;
end;


procedure TCuprexPohledForm.ViewModeBtnClick(Sender: TObject);
begin
 WorkBox.SetEditMode(emView);

end;

procedure TCuprexPohledForm.SpojModeBtnClick(Sender: TObject);
begin
 WorkBox.SetEditMode(emSpoje);
end;

procedure TCuprexPohledForm.ObrysModeBtnClick(Sender: TObject);
begin
 WorkBox.SetEditMode(emObrysy);
end;

procedure TCuprexPohledForm.ComboTloustkaChange(Sender: TObject);
begin
 WorkBox.SetStrWidth(ComboTloustka.Text);
 MyPohledAsistent.PrekresliPohledy;
end;

procedure TCuprexPohledForm.ComboHoleOutChange(Sender: TObject);
begin
 WorkBox.SetStrHoleOut(ComboHoleOut.Text);
 MyPohledAsistent.PrekresliPohledy;
end;

end.
