unit CuprexPohledAsistent;

interface

uses Forms, Classes, CuprexCanvasWriter;

type TInvForm = class(TForm)
      public
       procedure Prekresli; dynamic; abstract;
     end;
     TPohledRefPtr = ^TPohledRef;
     TPohledRef = record
      MyPohledForm : TInvForm;
      Predchozi, Dalsi : TPohledRefPtr;
     end;

     TCuprexPohledAsistent = class (TObject)
      private
       HlavniPohled : TPohledRefPtr;
       procedure ZapomenVsechno;
      public
       MyCanvasWriter : TCanvasWriter;
       constructor CreateOnCanvasWriter(CanvasWriter : TCanvasWriter);
       destructor Destroy; override;
       procedure NovyPohled (Owner : TComponent);
       procedure ZapomenPohled (Pohled : TForm);
       procedure PrekresliPohledy;
     end;
implementation

uses CuprexPohled;

Constructor TCuprexPohledAsistent.CreateOnCanvasWriter(CanvasWriter : TCanvasWriter);
begin
 inherited Create;
 HlavniPohled := nil;
 MyCanvasWriter := CanvasWriter;
end;

Destructor TCuprexPohledAsistent.Destroy;
begin
 ZapomenVsechno;
 inherited Destroy;
end;


Procedure TCuprexPohledAsistent.NovyPohled (Owner : TComponent);
var NovyPohled : TPohledRefPtr;
begin
 NovyPohled := nil;
 New(NovyPohled);
 If NovyPohled <> nil then
  begin
   NovyPohled^.Predchozi := nil;
   NovyPohled^.Dalsi := HlavniPohled;
   If HlavniPohled <> nil then HlavniPohled^.Predchozi := NovyPohled;
   HlavniPohled := NovyPohled;
   NovyPohled^.MyPohledForm := TCuprexPohledForm.CreateByAsistent (Owner, Self);
   NovyPohled^.MyPohledForm.Show;
  end;
end;

Procedure TCuprexPohledAsistent.ZapomenPohled (Pohled : TForm);
var Dalsi, Predchozi, Temp, Forget : TPohledRefPtr;
begin
 Temp := HlavniPohled;
 Forget := nil;
 While Temp <> nil do {najit zastupce}
  begin
   If Temp^.MyPohledForm = Pohled then Forget := Temp;
   Temp := Temp^.Dalsi;
  end;
 If Forget <> nil then {zruseni zastupce pohledu, nikoliv pohledu}
  begin
   Predchozi := Forget^.Predchozi;
   Dalsi := Forget^.Dalsi;
   Dispose(Forget); Forget := nil;
   If Predchozi <> nil then Predchozi^.Dalsi := Dalsi else HlavniPohled := Dalsi;
   If Dalsi <> nil then Dalsi^.Predchozi := Predchozi;
  end;
end;

Procedure TCuprexPohledAsistent.PrekresliPohledy;
var Temp : TPohledRefPtr;
begin
 Temp := HlavniPohled;
 While Temp <> nil do
  begin
   If Temp^.MyPohledForm <> nil then
    If Temp^.MyPohledForm.Visible then Temp^.MyPohledForm.Prekresli;
   Temp := Temp^.Dalsi;
  end;
end;

Procedure TCuprexPohledAsistent.ZapomenVsechno;
var Temp, Dalsi : TPohledRefPtr;
begin
 Temp := HlavniPohled;
 While Temp <> nil do
  begin
   Dalsi := Temp^.Dalsi;
   Dispose(Temp); Temp := nil;
   Temp := Dalsi;
  end;
end;

end.
