unit CuprexPrintLayout;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, Printers, StdCtrls,
  CuprexTypes, CuprexDataClass, CuprexCanvasWriter, CuprexNahledBox,
  ComCtrls;

type
  TCuprexPrintLayoutForm = class(TForm)
    GroupBoxPrinter: TGroupBox;
    LabelPNazev: TLabel;
    ComboBoxPrinters: TComboBox;
    ButtonOk: TButton;
    GroupBoxStranka: TGroupBox;
    LabelPVyska: TLabel;
    LabelPSirka: TLabel;
    LabelVyska: TLabel;
    LabelSirka: TLabel;
    LabelPZvetseni: TLabel;
    ButtonZvetsit: TButton;
    ButtonZmensit: TButton;
    LabelZvetseni: TLabel;
    ButtonStorno: TButton;
    LabelPMrizka: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    LabelPKopie: TLabel;
    UpDownKopie: TUpDown;
    EditKopie: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure ButtonZmensitClick(Sender: TObject);
    procedure ButtonZvetsitClick(Sender: TObject);
    procedure ButtonOkClick(Sender: TObject);
    procedure ButtonStornoClick(Sender: TObject);
    procedure ComboBoxPrintersChange(Sender: TObject);
  private
    NahledBox: TNahledBox;
    MinX, MinY, MaxX, MaxY : Pix;
    FScale : Word;
//    FXpos, FYpos : Sour;
    FGrid : TGrid;
    FPos : TPos;
//    Printer : TPrinter;
    CanvasWriter : TCanvasWriter;
    procedure RefreshNahled;

  public
    procedure SetMyCuprex (Cuprex: TCuprex);

  end;


implementation

{$R *.DFM}


Procedure TCuprexPrintLayoutForm.FormCreate(Sender: TObject);
begin
 MinX := 5;
 MinY := 5;
 MaxX := Width - 5;
 MaxY := Height - 5;
 FPos := DefPos;
 FGrid := DefGrid;
 FScale := DefScale;
 NahledBox := TNahledBox.Create (self);
 NahledBox.Parent := self;

 NahledBox.Width := 120;
 NahledBox.Height := 200;
 NahledBox.Left := 10;
 NahledBox.Top := 136;

 CanvasWriter := TCanvasWriter.Create;
 CanvasWriter.SetCuprex(nil);
 NahledBox.SetMyCanvasWriter(CanvasWriter);
// Printer := TPrinter.Create;
 ComboBoxPrinters.Items:=Printer.Printers;
 ComboBoxPrinters.Text:=Printer.Printers.Strings[Printer.PrinterIndex];
end;

Procedure TCuprexPrintLayoutForm.SetMyCuprex (Cuprex: TCuprex);
begin
  CanvasWriter.SetCuprex(Cuprex);
//  CanvasWriter.SetPosition(FPos);
//  CanvasWriter.SetScale(FScale);
//  CanvasWriter.SetGrid(FGrid);
//  CanvasWriter.SetOutputArea(MinX, MinY, MaxX, MaxY);
  Caption := 'Nhled: ' + Cuprex.GetSoubor;
  RefreshNahled;
end;


procedure TCuprexPrintLayoutForm.RefreshNahled;
var R : Real;
begin
 NahledBox.Height := 200;
 R := (Printer.PageWidth / Printer.PageHeight) * 200;
 NahledBox.Width := Round(R);
 NahledBox.Left := (GroupBoxStranka.Left - NahledBox.Width) div 2;
 NahledBox.Top := 90;
 R := (NahledBox.Height / Printer.PageHeight) * FScale;
 NahledBox.SetScale (Round(R));
 LabelVyska.Caption := IntToStr(Printer.PageHeight);
 LabelSirka.Caption := IntToStr(Printer.PageWidth);
 LabelZvetseni.Caption := IntToStr(FScale) + '%';
 NahledBox.Invalidate;
end;

procedure TCuprexPrintLayoutForm.ButtonZmensitClick(Sender: TObject);
begin
 If FScale > 20 then Dec(FScale,10);
 RefreshNahled;
end;

procedure TCuprexPrintLayoutForm.ButtonZvetsitClick(Sender: TObject);
begin
 If FScale < 990 then Inc(FScale,10);
 RefreshNahled;
end;

procedure TCuprexPrintLayoutForm.ButtonOkClick(Sender: TObject);
begin
 MinX := 5;
 MinY := 5;
 MaxX := Printer.PageWidth - 5;
 MaxY := Printer.PageHeight - 5;
 If CanvasWriter <> nil then
  begin
//   CanvasWriter.SetPosition(FPos);
//   CanvasWriter.SetScale(FScale);
//   CanvasWriter.SetGrid(FGrid);
//   CanvasWriter.SetOutputArea(MinX, MinY, MaxX, MaxY);
   try
    Printer.BeginDoc;
   {  CanvasWriter.CuprexNaCanvas(Printer.Canvas);}
   finally
    Printer.EndDoc;
   end;
  end;
end;

procedure TCuprexPrintLayoutForm.ButtonStornoClick(Sender: TObject);
begin
 Close;
end;

procedure TCuprexPrintLayoutForm.ComboBoxPrintersChange(Sender: TObject);
begin
 If Printer.Printers.Objects[ComboBoxPrinters.ItemIndex] <> nil then
  try
   Printer.PrinterIndex := ComboBoxPrinters.ItemIndex;
  except
   on EPrinter do
    begin
    end;
   on E: Exception do
    begin
     MessageDlg(E.Message, mtError, [mbOk], 0);
    end;
 end else ShowMessage('K tiskarne neni prirazen objekt.');
 RefreshNahled;
end;

end.
