{ Lukas Cerovsky - semestralni prace}
{ Komponenta pro zobrazovani a editaci Cuprexu}

unit CuprexWorkBox;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls, stdctrls,
  CuprexTypes, CuprexDataClass, CuprexCanvasWriter, CuprexPohledAsistent,
  dialogs, forms, CuprexKeyConst;

//const
 //   wkView = 0;
 //   wkSpoj = 1;
 //   wkObrys = 2;

type
  TChangeActiveEvent = procedure (Sender : TObject; Pohled : TPohled) of Object;
  TWorkBox = class(TCustomControl)
   private
     FMyCanvasWriter : TCanvasWriter;
     MinX, MinY, MaxX, MaxY : Pix;
     FChangeActive : TChangeActiveEvent;
 //    WorkMode : Byte;
   protected
     procedure Paint; override;
     procedure ChangeActive; dynamic;

     procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
     procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
     procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); override;
//     procedure KeyDown(var Key : Word; Shift : TShiftState);

     procedure WMKeyDown(var Message: TWMKeyDown); message WM_KEYDOWN;

   public
     FPohled : TPohled;
     FPohledAsistent : TCuprexPohledAsistent;

     constructor Create (AOwner: TComponent); override;
     destructor Destroy; override;
     procedure SetMyCanvasWriter (CanvasWriter: TCanvasWriter);
     procedure SetIntScale (const ScaleInt : word);
     procedure SetStrScale (const ScaleStr : string);
     procedure SetIntModul (const ModulInt : longint);
     procedure SetStrModul (const ModulStr : string);
     function GetStrModul : string;
     procedure SetStrWidth (const WidthStr : string);
     function GetStrWidth : string;
     procedure SetStrHoleIn (const HoleInStr : string);
     procedure SetStrHoleOut (const HoleOutStr : string);
     function GetStrHoleOut : string;
     procedure SetEditMode(AEditMode : Byte);

   published
     property OnChangeActive: TChangeActiveEvent read FChangeActive write FChangeActive;

  end;

procedure Register;

implementation

Constructor TWorkBox.Create (AOwner: TComponent);
begin
  inherited Create (AOwner);
  MinX := 5;
  MinY := 5;
  MaxX := Width-5;
  MaxY := Height-5;
  FMyCanvasWriter := nil;
  FPohled := DefPohled;
  FPohled.FGrid := DefGrid;
  FPohled.FPos := DefPos;
  FPohled.VirtFPos := DefPos;
  FPohled.FScale := DefScale;
  FPohled.Changed := DefChanged;
  FPohled.UnitsInPixel := defUnitsInPixel;
  ChangeActive;
  Cursor := crHandPoint;
  FPohledAsistent := nil;
end;

Destructor TWorkBox.Destroy;
begin
  inherited Destroy;
end;

Procedure TWorkBox.SetMyCanvasWriter (CanvasWriter: TCanvasWriter);
begin
  if CanvasWriter <> FMyCanvasWriter then FMyCanvasWriter := CanvasWriter;
  FPohled.UnitsInPixel := FMyCanvasWriter.FMyCuprex.FUnitsInPixel;
end;

procedure TWorkBox.ChangeActive;
begin
  if Assigned (FChangeActive) then FChangeActive (self, FPohled);
end;

Procedure TWorkBox.WMKeyDown(var Message: TWMKeyDown);
begin
 Case Message.CharCode of
  klIns : begin
           If FPohled.EditMode = emSpoje then FMyCanvasWriter.RozdelSpoj(FPohled);
           Invalidate;
          end;
  klSpace : begin
             If FPohled.EditMode = emSpoje then FMyCanvasWriter.VytvorSpoj(FPohled);
             FPohled.AktivniXYLocked := TRUE;
             Invalidate;
            end;
 end;
end;

Procedure TWorkBox.MouseMove(Shift: TShiftState; X, Y: Integer);
begin
 SetFocus;
 FMyCanvasWriter.NajdiNejblizsi (FPohled, X, Y);
 If NOT ((FPohled.Moving) OR (FPohled.AktivniXYLocked)) then
  begin
    If ((FPohled.Changed.Bod) OR (FPohled.Changed.Uzel))AND(FPohled.PointMode=pmOne) then
     Invalidate
    else
    begin
     FMyCanvasWriter.SetOutputArea(FPohled, 5, 5, Width-5, Height-5);
     FMyCanvasWriter.ZmenyNaCanvas(Canvas, FPohled);
    end;
  end;
 FMyCanvasWriter.SetMouseXY (FPohled, X, Y);
 ChangeActive;
 If ssLeft IN Shift then
  begin
   Case FPohled.EditMode of
     emView: begin
              FMyCanvasWriter.SetPohledPosByVirtual(FPohled,X,Y);
              Invalidate;
             end;
    emSpoje: begin
              FMyCanvasWriter.SetActiveXY (FPohled, X, Y);
              If FPohledAsistent <> nil then FPohledAsistent.PrekresliPohledy;
             end;
   emObrysy: begin
              FMyCanvasWriter.SetActiveXY (FPohled, X, Y);
              If FPohledAsistent <> nil then FPohledAsistent.PrekresliPohledy;
             end;
   end;
  end;
end;

Procedure TWorkBox.MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 SetFocus;
 If NOT FPohled.AktivniXYLocked then
  begin
   FPohled.AktivniX := nil;
   FPohled.AktivniY := nil;
   If Button = mbRight then
    begin
     FMyCanvasWriter.SetPohledPosition (X, Y, FPohled);
     FMyCanvasWriter.ZobrazPoziciXY (X,Y, FPohled);
    end;
   If Button = mbLeft then
    Case FPohled.EditMode of
     emView: begin
              FMyCanvasWriter.NewVirtualPos(FPohled,X,Y);
              FPohled.Moving := TRUE;
             end;
    emSpoje: begin
              If FPohled.AktivniBod <> nil then
               If FPohled.AktivniBod^.Attr AND caSelected = caSelected then
                begin
                 FPohled.AktivniX := @FPohled.AktivniBod^.X;
                 FPohled.AktivniY := @FPohled.AktivniBod^.Y;
                end;
              If (ssShift IN Shift)OR(ssCtrl IN Shift) then
               begin
                FMyCanvasWriter.FMyCuprex.OznacBod(FPohled.AktivniBod);
                FMyCanvasWriter.FMyCuprex.OznacSpoj(FPohled.AktivniSpoj);
               end else
               begin
                FMyCanvasWriter.FMyCuprex.OznacJedenBod(FPohled.AktivniBod);
                If FPohled.AktivniSpoj = nil then
                 FMyCanvasWriter.FMyCuprex.OznacJedenSpoj(FPohled.AktivniSpoj)
                 else
                 begin
                  If FPohled.AktivniSpoj^.Attr AND caSelected = caSelected then
                   FMyCanvasWriter.FMyCuprex.OznacVetev(FPohled.AktivniSpoj)
                   else FMyCanvasWriter.FMyCuprex.OznacJedenSpoj(FPohled.AktivniSpoj);
                  end;
               end;
              If FPohledAsistent <> nil then FPohledAsistent.PrekresliPohledy;
            {pocatek noveho spoje je aktivni bod, jinak novy bod na X, Y}
            {aktivniXY je druhy bod, vytvoreny na workplace}
           end;
   emObrysy: begin
              If FPohled.AktivniUzel <> nil then
               If FPohled.AktivniUzel^.Master <> nil then
                If FPohled.AktivniUzel^.Master^.Attr AND caSelected = caSelected then
                 begin
                  FPohled.AktivniX := @FPohled.AktivniUzel^.X;
                  FPohled.AktivniY := @FPohled.AktivniUzel^.Y;
                 end;
              FMyCanvasWriter.FMyCuprex.OznacJedenObrys(FPohled.AktivniObrys);
              If FPohledAsistent <> nil then FPohledAsistent.PrekresliPohledy;
              {jestlize je aktivniobrys = nil, bude se vytvaret novy obrys}
              {na masterskupine se zacne vytvaret novy obrys}
             end;
   end;
  end; 
 FPohled.AktivniXYLocked := TRUE;
end;

Procedure TWorkBox.MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
 FPohled.AktivniXYLocked := FALSE;
 FPohled.Moving := FALSE;
 Invalidate;
end;

Procedure TWorkBox.SetIntScale (const ScaleInt : word);
begin
 If (ScaleInt > minScale) AND (ScaleInt < maxScale) then
  begin
   FPohled.FScale := ScaleInt;
   Invalidate;
  end;
end;

Procedure TWorkBox.SetStrScale (const ScaleStr : string);
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0; If (I+Cnt <= Length(Zaznam)) then
   While (I+Cnt <= Length(Zaznam)) AND (Zaznam[I+Cnt] IN KtereZnaky) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;
var I, Cnt : Byte;
    ScaleStrF : string;
begin
 I:=1; Cnt:=0;
 Filtruj([#0..#255] - ['1'..'9'],ScaleStr,I,Cnt);
 ScaleStrF := Filtruj(['0'..'9'],ScaleStr,I,Cnt);
 SetIntScale(StrToInt(Copy(ScaleStrF,1,4)));
end;

Procedure TWorkBox.SetIntModul (const ModulInt : Longint);
begin
 If (ModulInt > minGridModul) AND (ModulInt < maxGridModul) then
  begin
   FPohled.FGrid.Modul := ModulInt;
   If FPohled.FGrid.Visible then Invalidate;
  end;
end;

Procedure TWorkBox.SetStrModul (const ModulStr : string);
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0; If (I+Cnt <= Length(Zaznam)) then
   While (I+Cnt <= Length(Zaznam)) AND (Zaznam[I+Cnt] IN KtereZnaky) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;
var I, Cnt : Byte;
    ModulStrF : string;
begin
 I:=1; Cnt:=0;
 Filtruj([#0..#255] - ['1'..'9'],ModulStr,I,Cnt);
 ModulStrF := Filtruj(['0'..'9'],ModulStr,I,Cnt);
 SetIntModul(StrToInt(Copy(ModulStrF,1,7)));
end;

Function TWorkBox.GetStrModul : string;
var Modul : Longint;
    ModulStr : string;
begin
 Modul := Round(FPohled.FGrid.Modul);
 Str(Modul, ModulStr);
 GetStrModul := ModulStr;
end;

Procedure TWorkBox.SetStrWidth (const WidthStr : string);
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0; If (I+Cnt <= Length(Zaznam)) then
   While (I+Cnt <= Length(Zaznam)) AND (Zaznam[I+Cnt] IN KtereZnaky) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;
var I, Cnt : Byte;
    WidthStrF : string;
begin
 I:=1; Cnt:=0;
 Filtruj([#0..#255] - ['0'..'9'],WidthStr,I,Cnt);
 WidthStrF := Filtruj(['0'..'9'],WidthStr,I,Cnt);
 FMyCanvasWriter.FMyCuprex.SetWidthToSelected(StrToInt(Copy(WidthStrF,1,7)));
end;

Procedure TWorkBox.SetStrHoleIn (const HoleInStr : string);
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0; If (I+Cnt <= Length(Zaznam)) then
   While (I+Cnt <= Length(Zaznam)) AND (Zaznam[I+Cnt] IN KtereZnaky) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;
var I, Cnt : Byte;
    HoleInStrF : string;
begin
 I:=1; Cnt:=0;
 Filtruj([#0..#255] - ['0'..'9'],HoleInStr,I,Cnt);
 HoleInStrF := Filtruj(['0'..'9'],HoleInStr,I,Cnt);
 FMyCanvasWriter.FMyCuprex.SetWidthToSelected(StrToInt(Copy(HoleInStrF,1,7)));
end;

Procedure TWorkBox.SetStrHoleOut (const HoleOutStr : string);
 Function Filtruj(KtereZnaky : Znaky; Zaznam : String; var I, Cnt : Byte) : String;
  begin
   I:=I+Cnt; Cnt:=0; If (I+Cnt <= Length(Zaznam)) then
   While (I+Cnt <= Length(Zaznam)) AND (Zaznam[I+Cnt] IN KtereZnaky) do Inc(Cnt);
   If Cnt > 0 then Filtruj := Copy(Zaznam,I,Cnt) else Filtruj := '0';
  end;
var I, Cnt : Byte;
    HoleOutStrF : string;
begin
 I:=1; Cnt:=0;
 Filtruj([#0..#255] - ['0'..'9'],HoleOutStr,I,Cnt);
 HoleOutStrF := Filtruj(['0'..'9'],HoleOutStr,I,Cnt);
 FMyCanvasWriter.FMyCuprex.SetHoleOutToSelected(StrToInt(Copy(HoleOutStrF,1,7)));
end;

Function TWorkBox.GetStrWidth : string;
var AWidth : Longint;
    AWidthStr : string;
begin
 If FPohled.AktivniSpoj <> nil then
  begin
   AWidth := Round(FPohled.AktivniSpoj^.Width);
   Str(AWidth, AWidthStr);
   GetStrWidth := AWidthStr;
  end else GetStrWidth := '0';
end;

Function TWorkBox.GetStrHoleOut : string;
var AHoleOut : Longint;
    AHoleOutStr : string;
begin
 If FPohled.AktivniBod <> nil then
  begin
   AHoleOut := Round(FPohled.AktivniBod^.HoleOut);
   Str(AHoleOut, AHoleOutStr);
   GetStrHoleOut := AHoleOutStr;
  end else GetStrHoleOut := '0';
end;

Procedure TWorkBox.SetEditMode(AEditMode : Byte);
begin
 FPohled.EditMode := AEditMode;
 Case FPohled.EditMode of
   emView: begin Cursor := crHandPoint; end;
  emSpoje: begin Cursor := crCross;  end;
 emObrysy: begin Cursor := crCross;  end;
 end;
 ChangeActive;
 Invalidate;
end;

Procedure TWorkBox.Paint;
begin
 with Canvas do
  begin
   Pen.Color:=clRed;
   Brush.Color:=clWhite;
   Rectangle(1,1,Width-1,Height-1);
  end;
 If FMyCanvasWriter <> nil then
  begin
   FMyCanvasWriter.SetOutputArea(FPohled, 5, 5, Width-5, Height-5);
   FMyCanvasWriter.CuprexNaCanvas(Canvas, FPohled);
  end;
end;

Procedure Register;
begin
  RegisterComponents('Samples', [TWorkBox]);
end;

end.
