unit KUI_reseni;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls,
  KUI_definice, Grids, ComCtrls;

type
  TFormReseni = class(TForm)
    ListBox1: TListBox;
    ListBox2: TListBox;
    GroupBoxSkupina: TGroupBox;
    ListBoxSkupina: TListBox;
    LabelPredTunelem: TLabel;
    LabelZaTunelem: TLabel;
    LabelTunel: TLabel;
    Timer1: TTimer;
    StatusBar1: TStatusBar;
    Image1: TImage;
    LabelTime: TLabel;
    procedure MoveWithGroup(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    Status : Integer;
    Counter : Integer;
    Cas : Integer;
    ResitRychle : Boolean;
    procedure GroupAt1(Action : Byte);
    procedure GroupAt2(Action : Byte);
    function DobaPrechodu(Hlava : TOsoba) : Integer;
    { Private declarations }
  public
    procedure Vyresit(Hlava : TOsoba; Rychle : Boolean);
    { Public declarations }
  end;

var
  FormReseni: TFormReseni;
  MyHlava: TOsoba;

implementation

{$R *.DFM}

procedure TFormReseni.Vyresit(Hlava : TOsoba; Rychle : Boolean);
var TempOsoba : TOsoba;
    Oznaceni : String;
begin
   MyHlava := Hlava;
   TempOsoba := Hlava;
   ListBox1.Clear;
   ListBox2.Clear;
   ListBoxSkupina.Clear;
   While (TempOsoba <> nil) do
    begin
     TempOsoba.Kde := PredTunelem;
     TempOsoba.HypKde := PredTunelem;
     Oznaceni := TempOsoba.Jmeno + ' ('+IntToStr(TempOsoba.Cas)+' minut)';
     FormReseni.ListBox1.Items.AddObject(Oznaceni, TempOsoba);
     TempOsoba := TempOsoba.Dalsi;
    end;
   ResitRychle := Rychle;
   Timer1.Enabled := TRUE;
   Status := 1;
   Counter := 0;
   Cas := 0;
end;

procedure TFormReseni.GroupAt1(Action : Byte);

//Usporada polozky v Items od nejmensi po nejvetsi necim jako bubble-sort
 procedure SortItems(Items : TStrings);
 var X1, X2, Xmin, WorkTime2, WorkTimeMin, UpTo : Integer;
 begin
  UpTo := Items.Count - 1;
  For X1 := 0 to UpTo do
   begin
    WorkTimeMin := (Items.Objects[X1] as TOsoba).Cas;
    X2 := X1;
    Xmin := X1;
    Repeat
     WorkTime2 := (Items.Objects[X2] as TOsoba).Cas;
     If (WorkTimeMin > WorkTime2) then
      begin
       WorkTimeMin := WorkTime2;
       Xmin := X2;
      end;
     Inc(X2);
    Until (X2 > UpTo);
    Items.Exchange(X1, Xmin);
   end;
 end;

//Vynuluje hypotetickou polohu osob
 procedure RefreshItems(Hlava : TOsoba);
 var TempOsoba : TOsoba;
 begin
  TempOsoba := Hlava;
  While (TempOsoba <> nil) do
   begin
    TempOsoba.HypKde := TempOsoba.Kde;
    TempOsoba := TempOsoba.Dalsi;
   end;
 end;

//Lidi z tunelu pred tunel
 procedure PredTunel(Hlava : TOsoba);
 var TempOsoba : TOsoba;
 begin
  TempOsoba := Hlava;
  While (TempOsoba <> nil) do
   begin
    If TempOsoba.Kde = VTunelu then TempOsoba.Kde := PredTunelem;
    TempOsoba := TempOsoba.Dalsi;
   end;
 end;

//vrati ohodnoceni tahu
 function GetRate(Hlava : TOsoba) : Integer;
 var DobaTam, DobaZpet, Zbytek : Integer;
     TempOsoba, OsobaZpet : TOsoba;
 begin
// najit nejpomalejsiho v tunelu a stav VTunelu zmenit na ZaTunelem
  TempOsoba := Hlava;
  DobaTam := 0;
  While (TempOsoba <> nil) do
   begin
    If TempOsoba.HypKde = VTunelu then
     begin
      If TempOsoba.Cas > DobaTam then DobaTam := TempOsoba.Cas;
      TempOsoba.HypKde := ZaTunelem;
     end;
    TempOsoba := TempOsoba.Dalsi;
   end;
// najit nejrychlejsiho za tunelem, pricist jeho cas k prechod a jeho stav na PredTunelem
  TempOsoba := Hlava;
  OsobaZpet := TempOsoba;
  DobaZpet := DobaTam;
  While (TempOsoba <> nil) do
   begin
    If TempOsoba.HypKde = ZaTunelem then
     begin
      If TempOsoba.Cas < DobaZpet then DobaZpet := TempOsoba.Cas;
      OsobaZpet := TempOsoba;
     end;
    TempOsoba := TempOsoba.Dalsi;
   end;
  OsobaZpet.HypKde := PredTunelem;
// spocitat soucet casu lidi pred tunelem
  TempOsoba := Hlava;
  Zbytek := 0;
  While (TempOsoba <> nil) do
   begin
    If TempOsoba.HypKde = PredTunelem then Inc(Zbytek, TempOsoba.Cas);
    TempOsoba := TempOsoba.Dalsi;
   end;
//vysledna hodnotici funkce
  GetRate := DobaTam + DobaZpet + Zbytek;
 end;

var X, Rate, MinRate, start, ofset, PocetOsob : Integer;

begin
 PocetOsob := 2;
 case Action of
  1: begin //polozky z ListBoxSkupina presunout do ListBox1 a nastavit jim stav ZaTunelem
      While ListBoxSkupina.Items.Count > 0 do
       begin
        ListBox1.Items.AddObject(ListBoxSkupina.Items.Strings[0],ListBoxSkupina.Items.Objects[0]);
        ListBoxSkupina.Items.Delete(0);
       end;
      PredTunel(MyHlava);
     end;
  2: begin //seradit osoby podle rychlosti
        SortItems(ListBox1.Items);
        MinRate := 0;
        start := 0;

        While (start + (PocetOsob-1) < ListBox1.Items.Count) do
         begin
          RefreshItems(MyHlava);
          For X:=0 to ListBox1.Items.Count-1 do
           (ListBox1.Items.Objects[X] as TOsoba).OptKde := (ListBox1.Items.Objects[X] as TOsoba).Kde;
          For ofset:=0 to PocetOsob-1 do
           begin
            if (start + ofset < ListBox1.Items.Count) then
               begin
                (ListBox1.Items.Objects[start+ofset] as TOsoba).HypKde:=VTunelu;
                (ListBox1.Items.Objects[start+ofset] as TOsoba).OptKde:=VTunelu;
               end;
           end;

          Rate := GetRate(MyHlava);
          If (Rate < MinRate)OR(MinRate = 0) then
           begin
            For X:=0 to ListBox1.Items.Count-1 do
             ListBox1.Selected[X]:=((ListBox1.Items.Objects[X] as TOsoba).OptKde = VTunelu);
            MinRate := Rate;
           end;
          Inc(start);
         end;

     end;
  3: begin
      X:=0;
      While X < ListBox1.Items.Count do
       If ListBox1.Selected[X] then
        begin
         ListBoxSkupina.Items.AddObject(ListBox1.Items.Strings[X],ListBox1.Items.Objects[X]);
         (ListBox1.Items.Objects[X] as TOsoba).Kde := VTunelu;
         ListBox1.Items.Delete(X);
        end else Inc(X);
     end;
 end;

end;

procedure TFormReseni.GroupAt2(Action : Byte);
//Usporada polozky v Items od nejmensi po nejvetsi necim jako bubble-sort
 procedure SortItems(Items : TStrings);
 var X1, X2, Xmin, WorkTime2, WorkTimeMin, UpTo : Integer;
 begin
  UpTo := Items.Count - 1;
  For X1 := 0 to UpTo do
   begin
    WorkTimeMin := (Items.Objects[X1] as TOsoba).Cas;
    X2 := X1;
    Xmin := X1;
    Repeat
     WorkTime2 := (Items.Objects[X2] as TOsoba).Cas;
     If (WorkTimeMin > WorkTime2) then
      begin
       WorkTimeMin := WorkTime2;
       Xmin := X2;
      end;
     Inc(X2);
    Until (X2 > UpTo);
    Items.Exchange(X1, Xmin);
   end;
 end;

//Lidi z tunelu za tunel
 procedure ZaTunel(Hlava : TOsoba);
 var TempOsoba : TOsoba;
 begin
  TempOsoba := Hlava;
  While (TempOsoba <> nil) do
   begin
    If TempOsoba.Kde = VTunelu then TempOsoba.Kde := ZaTunelem;
    TempOsoba := TempOsoba.Dalsi;
   end;
 end;

begin
 case Action of
  1: begin //polozky z ListBoxSkupina presunout do ListBox2 a nastavit jim stav ZaTunelem
      While ListBoxSkupina.Items.Count > 0 do
       begin
        ListBox2.Items.AddObject(ListBoxSkupina.Items.Strings[0],ListBoxSkupina.Items.Objects[0]);
        ListBoxSkupina.Items.Delete(0);
       end;
      ZaTunel(MyHlava);
      If ListBox1.Items.Count = 0 then Status := 9;
     end;
  2: begin //najit nejrychlejsiho a oznacit ho
      SortItems(ListBox2.Items);
      If ListBox2.Items.Count > 0 then
       begin
        ListBox2.Selected[0]:=TRUE;
       end;
     end;
  3: begin
      If ListBox2.Items.Count > 0 then
       begin
        ListBoxSkupina.Items.AddObject(ListBox2.Items.Strings[0],ListBox2.Items.Objects[0]);
        (ListBox2.Items.Objects[0] as TOsoba).Kde := VTunelu;
        ListBox2.Items.Delete(0);
       end;
     end;
 end;
end;

function TFormReseni.DobaPrechodu(Hlava : TOsoba) : Integer;
var TempOsoba : TOsoba;
    MaxCas : Integer;
begin
 TempOsoba := Hlava;
 MaxCas := 0;
 While (TempOsoba <> nil) do
  begin
   If (TempOsoba.Cas > MaxCas) AND (TempOsoba.Kde = VTunelu) then MaxCas := TempOsoba.Cas;
   TempOsoba := TempOsoba.Dalsi;
  end;
 DobaPrechodu := MaxCas;
end;

procedure TFormReseni.MoveWithGroup(Sender: TObject);
const PopisStavu : array[0..9] of String =
('Pipraven k een.','Pprava na cestu do tunelu','Vytven skupiny pro prchod tunelem',
 'Prchod tunelem...','Skupina za tunelem','Pprava na cestu do tunelu','Vytven skupiny pro prchod tunelem',
 'Prchod tunelem...','Skupina ped tunelem','kol dokonen.');
begin
 Inc(Counter);
 If (Status <> 0) then
  If (Counter > 50) OR (ResitRychle) then
   begin
    If StatusBar1.Panels.Items[0].Bevel = pbLowered
      then StatusBar1.Panels.Items[0].Bevel:=pbRaised
      else StatusBar1.Panels.Items[0].Bevel:=pbLowered;
    Case Status of
     1: GroupAt1(2); // priprava na cestu, oznaceni osob pro prepravu
     2: GroupAt1(3); // nastoupeni
     3: Cas := Cas + DobaPrechodu(MyHlava); //cesta tam
     4: GroupAt2(1); // vystoupeni
     5: GroupAt2(2); // priprava na cestu oznaceni
     6: GroupAt2(3); // nastoupeni
     7: Cas := Cas + DobaPrechodu(MyHlava); //cesta zpet
     8: GroupAt1(1); // vystoupeni
     9: begin
         Timer1.Enabled := FALSE;
         MessageDlg('kol splnn v ase '+IntToStr(Cas)+' minut.',mtInformation,[mbOK],0);
        end;
    end;
    If Status <> 9 then If Status < 8 then Inc(Status) else Status := 1;
    StatusBar1.Panels.Items[1].Text:='as: '+IntToStr(Cas);
    LabelTime.Caption := IntToStr(Cas)+' min.';
    StatusBar1.Panels.Items[2].Text:=PopisStavu[Status];
    Counter := 0;
   end;
 If Status = 3 then
  begin
   GroupBoxSkupina.Left := ((Counter * (ListBox2.Left - ListBox1.Left)) div 50)
  end;
 If Status = 7 then
  begin
   GroupBoxSkupina.Left := (((50 - Counter) * (ListBox2.Left - ListBox1.Left)) div 50)
  end;
end;


procedure TFormReseni.FormCreate(Sender: TObject);
begin
 FormReseni.BorderIcons := [biSystemMenu, biMinimize];
end;

end.
