unit KUI_zadani;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ComCtrls,
  KUI_definice, KUI_reseni;

type
  TFormMain = class(TForm)
    GroupBoxZadani: TGroupBox;
    LabelZadani: TLabel;
    GroupBox1: TGroupBox;
    ListBox: TListBox;
    Edit: TEdit;
    ButtonAdd: TButton;
    ButtonRemove: TButton;
    ButtonGo: TButton;
    LabelOsobaCas: TLabel;
    LabelSeznam: TLabel;
    LabelOsobaBarva: TLabel;
    EditOsobaJmeno: TEdit;
    ButtonGoFast: TButton;
    procedure SetDefaults(Sender: TObject);
    procedure ButtonAddClick(Sender: TObject);
    procedure ButtonRemoveClick(Sender: TObject);
    procedure ListBoxClick(Sender: TObject);
    procedure ButtonGoClick(Sender: TObject);
    procedure ButtonGoFastClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FormMain: TFormMain; // formular zadani
  Hlava: TOsoba; // hlava seznamu osob

implementation

{$R *.DFM}

procedure TFormMain.SetDefaults(Sender: TObject);
begin
 Hlava := nil;
 FormMain.BorderIcons := [biSystemMenu, biMinimize];
 FormMain.LabelZadani.Caption :=
  'Zadan poet osob m projt tunelem v nejkrat ase.' + Chr(13)+Chr(10) +
  'K cest je zapoteb baterka, k dispozici je pouze jedna.' + Chr(13)+Chr(10) +
  'Osoby mohou jt ve skupin, maximln po dvou osobch.' + Chr(13)+Chr(10) +
  'Kad osob trv prchod tunelem urit dan as.' + Chr(13)+Chr(10) +
  'Skupina s baterkou se pohybuje tempem nejpomalejho lena.';
end;

procedure TFormMain.ButtonAddClick(Sender: TObject);
var JmenoOsoby : string;
    CasOsoby : integer;
    OznaceniOsoby : string;
    Osoba : TOsoba;
begin
 JmenoOsoby := FormMain.EditOsobaJmeno.Text;
 CasOsoby := StrToInt(FormMain.Edit.Text);

 Osoba := TOsoba.Create;
 Osoba.Dalsi := Hlava;
 Osoba.Self := Osoba;
 Osoba.Cas := CasOsoby;
 Osoba.Jmeno := JmenoOsoby;
 Hlava := Osoba;
 OznaceniOsoby := Osoba.Jmeno + ' ('+IntToStr(Osoba.Cas)+' minut)';
 FormMain.ListBox.Items.AddObject(OznaceniOsoby,Osoba);
end;

procedure TFormMain.ButtonRemoveClick(Sender: TObject);
var RusenaOsoba : TOsoba;
    TempOsoba : TOsoba;
begin
 If FormMain.ListBox.ItemIndex >= 0 then
  begin
   RusenaOsoba := (FormMain.ListBox.Items.Objects[FormMain.ListBox.ItemIndex] as TOsoba);
   FormMain.ListBox.Items.Delete(FormMain.ListBox.ItemIndex);
   //najit kdo na rusenou osobu ukazuje
   //at ted ukazuje na naslednika rusene osoby
   //zrusit rusenou osobu
   TempOsoba := Hlava;
   If TempOsoba <> nil then
    begin
     While (TempOsoba.Dalsi <> nil) AND (TempOsoba.Dalsi <> RusenaOsoba) do TempOsoba := TempOsoba.Dalsi;
     If Hlava = RusenaOsoba then Hlava := RusenaOsoba.Dalsi;
     If TempOsoba.Dalsi = RusenaOsoba then TempOsoba.Self.Dalsi := RusenaOsoba.Dalsi;
    end;
//   ShowMessage('Dalsi:'+TempOsoba.Self.Jmeno+' rusena:'+RusenaOsoba.Jmeno);
   RusenaOsoba.Destroy;
  end;
 FormMain.ButtonRemove.Enabled := FALSE;
end;

procedure TFormMain.ListBoxClick(Sender: TObject);
var AktivniOsoba : TOsoba;
begin
 If FormMain.ListBox.ItemIndex >= 0 then
  begin
   AktivniOsoba := FormMain.ListBox.Items.Objects[FormMain.ListBox.ItemIndex] as TOsoba;
   FormMain.EditOsobaJmeno.Text := AktivniOsoba.Jmeno;
   FormMain.Edit.Text := IntToStr(AktivniOsoba.Cas);
   FormMain.ButtonRemove.Enabled := TRUE;
  end;
end;

procedure TFormMain.ButtonGoClick(Sender: TObject);
begin
   FormReseni.Vyresit(Hlava, FALSE);
   FormReseni.Show;
end;

procedure TFormMain.ButtonGoFastClick(Sender: TObject);
begin
   FormReseni.Vyresit(Hlava, TRUE);
   FormReseni.Show;
end;

end.
